/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.ManagedThreadFactory;
import org.activiti.engine.impl.jobexecutor.DefaultJobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedJobExecutor
extends DefaultJobExecutor {
    private static Logger log = LoggerFactory.getLogger(ManagedJobExecutor.class);
    protected ManagedThreadFactory threadFactory;

    public ManagedThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ManagedThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    protected void startExecutingJobs() {
        if (this.threadFactory == null) {
            log.warn("A managed thread factory was not found, falling back to self-managed threads");
            super.startExecutingJobs();
        } else {
            if (this.threadPoolQueue == null) {
                this.threadPoolQueue = new ArrayBlockingQueue(this.queueSize);
            }
            if (this.threadPoolExecutor == null) {
                this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.threadPoolQueue, (ThreadFactory)this.threadFactory);
                this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
            }
            this.startJobAcquisitionThread();
        }
    }
}

