/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.bpmn.model.Signal;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.behavior.BpmnActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.SignallableActivityBehavior;

public abstract class FlowNodeActivityBehavior
implements SignallableActivityBehavior {
    public final String FIRED_EVENT_SIGNAL_FORMAT = "firedEventSignal_%s_%s";
    private static final Pattern scopeRegexPattern = Pattern.compile("\"scope\"\\s*:\\s*\"([^\"]+)\",?");
    protected BpmnActivityBehavior bpmnActivityBehavior = new BpmnActivityBehavior();

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        this.leave(execution);
    }

    protected void leave(ActivityExecution execution) {
        this.bpmnActivityBehavior.performDefaultOutgoingBehavior(execution);
    }

    protected void leaveIgnoreConditions(ActivityExecution activityContext) {
        this.bpmnActivityBehavior.performIgnoreConditionsOutgoingBehavior(activityContext);
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        throw new ActivitiException("this activity doesn't accept signals");
    }

    protected void registerFiredSignalEvent(ActivityExecution execution, Signal signal) {
        String signalScope = this.getSignalScope(execution, signal);
        Context.getCommandContext().addAttribute(signalScope, true);
    }

    protected boolean isSignalEventAlreadyFired(ActivityExecution execution, EventSubscriptionEntity subscription) {
        if (!this.isSignalEventType(subscription)) {
            return false;
        }
        String subscriptionScope = this.getEventSubscriptionScope(execution, subscription);
        return Context.getCommandContext().getAttribute(subscriptionScope) != null;
    }

    protected boolean isSignalEventType(EventSubscriptionEntity subscription) {
        return "signal".equals(subscription.getEventType());
    }

    protected String getEventSubscriptionScope(ActivityExecution execution, EventSubscriptionEntity subscription) {
        Matcher matcher;
        String subscriptionScope = null;
        if (subscription.getConfiguration() != null && (matcher = scopeRegexPattern.matcher(subscription.getConfiguration())).find()) {
            subscriptionScope = matcher.group(1);
        }
        return this.getSignalExecutionScope(execution, subscription.getEventName(), subscriptionScope);
    }

    protected String getSignalScope(ActivityExecution execution, Signal signal) {
        return this.getSignalExecutionScope(execution, signal.getName(), signal.getScope());
    }

    protected String getSignalExecutionScope(ActivityExecution execution, String signalName, String signalScope) {
        return String.format("firedEventSignal_%s_%s", signalName, "processInstance".equals(signalScope) ? execution.getProcessInstanceId() : "global");
    }
}

