/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.ArrayList;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationType;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.jobexecutor.TimerStartEventJobHandler;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerEventDefinitionParseHandler
extends AbstractBpmnParseHandler<TimerEventDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(TimerEventDefinitionParseHandler.class);
    public static final String PROPERTYNAME_START_TIMER = "timerStart";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return TimerEventDefinition.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, TimerEventDefinition timerEventDefinition) {
        ActivityImpl timerActivity = bpmnParse.getCurrentActivity();
        if (bpmnParse.getCurrentFlowElement() instanceof StartEvent) {
            ProcessDefinitionEntity processDefinition = bpmnParse.getCurrentProcessDefinition();
            timerActivity.setProperty("type", "startTimerEvent");
            TimerDeclarationImpl timerDeclaration = this.createTimer(bpmnParse, timerEventDefinition, timerActivity, "timer-start-event");
            String jobHandlerConfiguration = timerDeclaration.getJobHandlerConfiguration();
            Map<String, JobHandler> jobHandlers = Context.getProcessEngineConfiguration().getJobHandlers();
            JobHandler jobHandler = jobHandlers.get("timer-start-event");
            jobHandlerConfiguration = ((TimerEventHandler)((Object)jobHandler)).setProcessDefinitionKeyToConfiguration(jobHandlerConfiguration, processDefinition.getKey());
            jobHandlerConfiguration = ((TimerEventHandler)((Object)jobHandler)).setActivityIdToConfiguration(jobHandlerConfiguration, timerActivity.getId());
            timerDeclaration.setJobHandlerConfiguration(jobHandlerConfiguration);
            ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)processDefinition.getProperty(PROPERTYNAME_START_TIMER);
            if (timerDeclarations == null) {
                timerDeclarations = new ArrayList<TimerDeclarationImpl>();
                processDefinition.setProperty(PROPERTYNAME_START_TIMER, timerDeclarations);
            }
            timerDeclarations.add(timerDeclaration);
        } else if (bpmnParse.getCurrentFlowElement() instanceof IntermediateCatchEvent) {
            timerActivity.setProperty("type", "intermediateTimer");
            TimerDeclarationImpl timerDeclaration = this.createTimer(bpmnParse, timerEventDefinition, timerActivity, "timer-intermediate-transition");
            if (this.getPrecedingEventBasedGateway(bpmnParse, (IntermediateCatchEvent)bpmnParse.getCurrentFlowElement()) != null) {
                this.addTimerDeclaration(timerActivity.getParent(), timerDeclaration);
            } else {
                this.addTimerDeclaration(timerActivity, timerDeclaration);
                timerActivity.setScope(true);
            }
        } else if (bpmnParse.getCurrentFlowElement() instanceof BoundaryEvent) {
            timerActivity.setProperty("type", "boundaryTimer");
            TimerDeclarationImpl timerDeclaration = this.createTimer(bpmnParse, timerEventDefinition, timerActivity, "timer-transition");
            BoundaryEvent boundaryEvent = (BoundaryEvent)bpmnParse.getCurrentFlowElement();
            boolean interrupting = boundaryEvent.isCancelActivity();
            if (interrupting) {
                timerDeclaration.setInterruptingTimer(true);
            }
            this.addTimerDeclaration(timerActivity.getParent(), timerDeclaration);
            if (timerActivity.getParent() instanceof ActivityImpl) {
                ((ActivityImpl)timerActivity.getParent()).setScope(true);
            }
            timerActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createBoundaryEventActivityBehavior((BoundaryEvent)bpmnParse.getCurrentFlowElement(), interrupting, timerActivity));
        }
    }

    protected TimerDeclarationImpl createTimer(BpmnParse bpmnParse, TimerEventDefinition timerEventDefinition, ScopeImpl timerActivity, String jobHandlerType) {
        TimerDeclarationType type = null;
        Expression expression = null;
        Expression endDate = null;
        Expression calendarName = null;
        ExpressionManager expressionManager = bpmnParse.getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeDate())) {
            type = TimerDeclarationType.DATE;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDate());
        } else if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeCycle())) {
            type = TimerDeclarationType.CYCLE;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeCycle());
            if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getEndDate())) {
                endDate = expressionManager.createExpression(timerEventDefinition.getEndDate());
            }
        } else if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeDuration())) {
            type = TimerDeclarationType.DURATION;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDuration());
        }
        if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getCalendarName())) {
            calendarName = expressionManager.createExpression(timerEventDefinition.getCalendarName());
        }
        if (expression == null) {
            logger.warn("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed) (" + timerActivity.getId() + ")");
        }
        String jobHandlerConfiguration = timerActivity.getId();
        if (jobHandlerType.equalsIgnoreCase("timer-transition") || jobHandlerType.equalsIgnoreCase("timer-intermediate-transition") || jobHandlerType.equalsIgnoreCase("timer-start-event")) {
            jobHandlerConfiguration = TimerStartEventJobHandler.createConfiguration(timerActivity.getId(), endDate, calendarName);
        }
        TimerDeclarationImpl timerDeclaration = new TimerDeclarationImpl(expression, type, jobHandlerType, endDate, calendarName);
        timerDeclaration.setJobHandlerConfiguration(jobHandlerConfiguration);
        timerDeclaration.setExclusive(true);
        return timerDeclaration;
    }

    protected void addTimerDeclaration(ScopeImpl scope, TimerDeclarationImpl timerDeclaration) {
        ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)scope.getProperty("timerDeclarations");
        if (timerDeclarations == null) {
            timerDeclarations = new ArrayList<TimerDeclarationImpl>();
            scope.setProperty("timerDeclarations", timerDeclarations);
        }
        timerDeclarations.add(timerDeclaration);
    }
}

