/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.util.CommandExecutor;
import org.activiti.engine.impl.util.ShellExecutorContext;

public class ShellCommandExecutor
implements CommandExecutor {
    private Boolean waitFlag;
    private final Boolean cleanEnvBoolan;
    private final Boolean redirectErrorFlag;
    private final String directoryStr;
    private final String resultVariableStr;
    private final String errorCodeVariableStr;
    private final List<String> argList;

    public ShellCommandExecutor(Boolean waitFlag, Boolean cleanEnvBoolan, Boolean redirectErrorFlag, String directoryStr, String resultVariableStr, String errorCodeVariableStr, List<String> argList) {
        this.waitFlag = waitFlag;
        this.cleanEnvBoolan = cleanEnvBoolan;
        this.redirectErrorFlag = redirectErrorFlag;
        this.directoryStr = directoryStr;
        this.resultVariableStr = resultVariableStr;
        this.errorCodeVariableStr = errorCodeVariableStr;
        this.argList = argList;
    }

    public ShellCommandExecutor(ShellExecutorContext context) {
        this(context.getWaitFlag(), context.getCleanEnvBoolan(), context.getRedirectErrorFlag(), context.getDirectoryStr(), context.getResultVariableStr(), context.getErrorCodeVariableStr(), context.getArgList());
    }

    @Override
    public void executeCommand(ActivityExecution execution) throws Exception {
        if (this.argList != null && this.argList.size() > 0) {
            ProcessBuilder processBuilder = new ProcessBuilder(this.argList);
            processBuilder.redirectErrorStream(this.getRedirectErrorFlag());
            if (this.getCleanEnvBoolan().booleanValue()) {
                Map<String, String> env = processBuilder.environment();
                env.clear();
            }
            if (this.getDirectoryStr() != null && this.getDirectoryStr().length() > 0) {
                processBuilder.directory(new File(this.getDirectoryStr()));
            }
            Process process = processBuilder.start();
            if (this.getWaitFlag().booleanValue()) {
                int errorCode = process.waitFor();
                if (this.getResultVariableStr() != null) {
                    String result = this.convertStreamToStr(process.getInputStream());
                    execution.setVariable(this.getResultVariableStr(), result);
                }
                if (this.getErrorCodeVariableStr() != null) {
                    execution.setVariable(this.getErrorCodeVariableStr(), Integer.toString(errorCode));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToStr(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public Boolean getWaitFlag() {
        return this.waitFlag;
    }

    public void setWaitFlag(Boolean waitFlag) {
        this.waitFlag = waitFlag;
    }

    public Boolean getCleanEnvBoolan() {
        return this.cleanEnvBoolan;
    }

    public Boolean getRedirectErrorFlag() {
        return this.redirectErrorFlag;
    }

    public String getDirectoryStr() {
        return this.directoryStr;
    }

    public String getResultVariableStr() {
        return this.resultVariableStr;
    }

    public String getErrorCodeVariableStr() {
        return this.errorCodeVariableStr;
    }

    public List<String> getArgList() {
        return this.argList;
    }
}

