/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.activiti.editor.constants.EditorJsonConstants;
import org.activiti.editor.constants.StencilConstants;

public class JsonConverterUtil
implements EditorJsonConstants,
StencilConstants {
    public static String getPropertyValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = JsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !"null".equalsIgnoreCase(propertyNode.asText())) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static boolean getPropertyValueAsBoolean(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsBoolean(name, objectNode, false);
    }

    public static boolean getPropertyValueAsBoolean(String name, JsonNode objectNode, boolean defaultValue) {
        boolean result = defaultValue;
        String stringValue = JsonConverterUtil.getPropertyValueAsString(name, objectNode);
        if ("Yes".equalsIgnoreCase(stringValue)) {
            result = true;
        } else if ("No".equalsIgnoreCase(stringValue)) {
            result = false;
        }
        return result;
    }

    public static List<String> getPropertyValueAsList(String name, JsonNode objectNode) {
        ArrayList<String> resultList = new ArrayList<String>();
        JsonNode propertyNode = JsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !"null".equalsIgnoreCase(propertyNode.asText())) {
            String[] valueList;
            String propertyValue = propertyNode.asText();
            for (String value : valueList = propertyValue.split(",")) {
                resultList.add(value.trim());
            }
        }
        return resultList;
    }

    public static JsonNode getProperty(String name, JsonNode objectNode) {
        JsonNode propertyNode = null;
        if (objectNode.get("properties") != null) {
            JsonNode propertiesNode = objectNode.get("properties");
            propertyNode = propertiesNode.get(name);
        }
        return propertyNode;
    }
}

