/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input.awt;

import java.util.Arrays;
import org.jemmy.Point;
import org.jemmy.Rectangle;
import org.jemmy.action.Action;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;
import org.jemmy.env.Timeout;
import org.jemmy.input.awt.RobotDriver;
import org.jemmy.interfaces.Modifier;
import org.jemmy.interfaces.Mouse;
import org.jemmy.interfaces.Showable;

public class MouseImpl
implements Mouse {
    private Wrap<?> target;
    private RobotDriver robotDriver;
    private boolean detached = false;

    public MouseImpl(Wrap<?> target) {
        this.target = target;
        this.robotDriver = new RobotDriver(new Timeout("", 10L));
    }

    public Mouse detached() {
        this.detached = true;
        return this;
    }

    private void runAction(Action action) {
        if (this.detached) {
            this.target.getEnvironment().getExecutor().executeDetached(this.target.getEnvironment(), false, action, new Object[0]);
        } else {
            this.target.getEnvironment().getExecutor().execute(this.target.getEnvironment(), false, action, new Object[0]);
        }
    }

    public void press() {
        this.press((Mouse.MouseButton)Mouse.MouseButtons.BUTTON1);
    }

    public void press(Mouse.MouseButton button) {
        this.press(button, new Modifier[0]);
    }

    public void press(final Mouse.MouseButton button, final Modifier ... modifiers) {
        this.runAction(new Action(){

            public void run(Object ... parameters) {
                MouseImpl.this.robotDriver.pressMouse(button, modifiers);
            }

            public String toString() {
                return "pressing mouse button " + button + " with " + modifiers + " modifiers";
            }
        });
    }

    public void release() {
        this.release((Mouse.MouseButton)Mouse.MouseButtons.BUTTON1);
    }

    public void release(Mouse.MouseButton button) {
        this.release(button, new Modifier[0]);
    }

    public void release(final Mouse.MouseButton button, final Modifier ... modifiers) {
        this.runAction(new Action(){

            public void run(Object ... parameters) {
                MouseImpl.this.robotDriver.releaseMouse(button, modifiers);
            }

            public String toString() {
                return "releasing mouse button " + button + " with " + modifiers + " modifiers";
            }
        });
    }

    public void move() {
        this.move(this.target.getClickPoint());
    }

    public void move(final Point p) {
        this.runAction(new Action(){

            public void run(Object ... parameters) {
                MouseImpl.this.robotDriver.moveMouse(MouseImpl.getAbsolute(MouseImpl.this.target, p));
            }

            public String toString() {
                return "moving mouse to " + p;
            }
        });
    }

    public void click() {
        this.click(1);
    }

    public void click(int count) {
        this.click(count, null);
    }

    public void click(int count, Point p) {
        this.click(count, p, (Mouse.MouseButton)Mouse.MouseButtons.BUTTON1);
    }

    public void click(int count, Point p, Mouse.MouseButton button) {
        this.click(count, p, button, new Modifier[0]);
    }

    public void click(final int count, final Point p, final Mouse.MouseButton button, final Modifier ... modifiers) {
        this.runAction(new Action(){

            public void run(Object ... parameters) {
                if (MouseImpl.this.target.is(Showable.class)) {
                    ((Showable)MouseImpl.this.target.as(Showable.class)).shower().show();
                }
                MouseImpl.this.robotDriver.clickMouse(MouseImpl.getAbsolute(MouseImpl.this.target, p == null ? MouseImpl.this.target.getClickPoint() : p), count, button, MouseImpl.this.target.getEnvironment().getTimeout(Mouse.CLICK), modifiers);
            }

            public String toString() {
                return "clicking " + button + " mouse button " + count + " times at " + p + " with " + Arrays.toString(modifiers) + " modifiers";
            }
        });
    }

    static Point getAbsolute(Wrap<?> target, Point p) {
        Rectangle screenBounds = target.getScreenBounds();
        return new Point(p.x + screenBounds.x, p.y + screenBounds.y);
    }

    private void turn(final Point p, final int amount, final Modifier ... modifiers) {
        this.runAction(new Action(){

            public void run(Object ... parameters) {
                if (MouseImpl.this.target.is(Showable.class)) {
                    ((Showable)MouseImpl.this.target.as(Showable.class)).shower().show();
                }
                MouseImpl.this.robotDriver.turnWheel(MouseImpl.getAbsolute(MouseImpl.this.target, p == null ? MouseImpl.this.target.getClickPoint() : p), amount, modifiers);
            }

            public String toString() {
                return "turning wheel to " + amount + " with " + Arrays.toString(modifiers) + " modifiers";
            }
        });
    }

    public void turnWheel(Point point, int amount, Modifier ... modifiers) {
        this.turn(point, amount, modifiers);
    }

    public void turnWheel(Point point, int amount) {
        this.turn(point, amount, new Modifier[0]);
    }

    public void turnWheel(int amount) {
        this.turn(null, amount, new Modifier[0]);
    }

    static {
        if (Environment.getEnvironment().getTimeout(CLICK) == null) {
            Environment.getEnvironment().setTimeout(CLICK);
        }
    }
}

