/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input.awt;

import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jemmy.JemmyException;
import org.jemmy.Rectangle;
import org.jemmy.env.Environment;
import org.jemmy.env.Timeout;
import org.jemmy.image.Image;
import org.jemmy.image.awt.AWTImage;
import org.jemmy.image.awt.PNGDecoder;
import org.jemmy.image.awt.PNGEncoder;
import org.jemmy.input.awt.AWTMap;
import org.jemmy.input.awt.AWTRobotInputFactory;
import org.jemmy.input.awt.ClassReference;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Mouse;
import org.jemmy.timing.State;
import org.jemmy.timing.Waiter;

class RobotExecutor {
    private static RobotExecutor instance;
    private AWTMap awtMap = null;
    protected ClassReference robotReference = null;
    protected Timeout autoDelay;
    private boolean inited = false;
    private boolean runInOtherJVM = false;
    private boolean ready = false;
    private boolean connectionEstablished = false;
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private Socket socket;
    private int connectionPort;
    private String connectionHost;
    public static final int CONNECTION_TIMEOUT;
    private static final Set<String> convertables;
    private File props;

    public static RobotExecutor get() {
        if (instance == null) {
            instance = new RobotExecutor();
        }
        return instance;
    }

    void setAWTMap(AWTMap awtMap) {
        this.awtMap = awtMap;
    }

    AWTMap getAWTMap() {
        if (this.awtMap == null) {
            this.awtMap = new AWTMap();
        }
        return this.awtMap;
    }

    private void ensureInited() {
        if (!this.inited) {
            this.runInOtherJVM = Boolean.parseBoolean((String)Environment.getEnvironment().getProperty("awt.robot.othervm", (Object)Boolean.toString(this.runInOtherJVM)));
            this.inited = true;
        }
    }

    public Image createScreenCapture(Rectangle screenRect) {
        Object result = this.makeAnOperation("createScreenCapture", new Object[]{new java.awt.Rectangle(screenRect.x, screenRect.y, screenRect.width, screenRect.height)}, new Class[]{java.awt.Rectangle.class});
        if (result.getClass().isAssignableFrom(BufferedImage.class)) {
            return new AWTImage((BufferedImage)BufferedImage.class.cast(result));
        }
        throw new JemmyException("Screen capture (" + result + ") is not a BufferedImage");
    }

    public Object makeAnOperation(String method, Object[] params, Class[] paramClasses) {
        this.ensureInited();
        if (this.runInOtherJVM) {
            return this.makeAnOperationRemotely(method, params, paramClasses);
        }
        return this.makeAnOperationLocally(method, params, paramClasses);
    }

    public void exit() {
        this.ensureInited();
        if (this.runInOtherJVM) {
            this.ensureConnection();
            try {
                this.outputStream.writeObject("exit");
                this.connectionEstablished = false;
                this.deleteProperties();
            }
            catch (IOException ex) {
                throw new JemmyException("Failed to invoke exit", (Throwable)ex);
            }
        }
    }

    private Object makeAnOperationLocally(String method, Object[] params, Class[] paramClasses) {
        if (this.robotReference == null) {
            this.initRobot();
        }
        try {
            this.convert(method, params, paramClasses);
            Object result = this.robotReference.invokeMethod(method, params, paramClasses);
            this.synchronizeRobot();
            return result;
        }
        catch (InvocationTargetException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
    }

    private int convert(Object obj) {
        if (Mouse.MouseButton.class.isAssignableFrom(obj.getClass())) {
            return this.awtMap.convert((Mouse.MouseButton)obj);
        }
        if (Keyboard.KeyboardButton.class.isAssignableFrom(obj.getClass())) {
            return this.awtMap.convert((Keyboard.KeyboardButton)obj);
        }
        throw new JemmyException("Unable to recognize object", obj);
    }

    private void convert(String method, Object[] params, Class[] paramClasses) {
        if (convertables.contains(method)) {
            for (int i = 0; i < params.length; ++i) {
                params[i] = new Integer(this.convert(params[i]));
                paramClasses[i] = Integer.TYPE;
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        if (args.length != 0 && args.length != 1) {
            System.err.println("Usage: java ... [-Djemmy.properties=<.jemmy.properties full path>] RobotExecutor [connectionPort]");
            System.exit(-1);
        }
        if (args.length == 1) {
            Environment.getEnvironment().setProperty("awt.robot.othervm.port", (Object)args[0]);
        }
        RobotExecutor re = new RobotExecutor();
        try {
            re.server();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.flush();
            System.exit(-1);
        }
    }

    private void deleteProperties() {
        if (this.props != null) {
            this.props.delete();
            this.props = null;
        }
    }

    private void prepareProperties() {
        this.deleteProperties();
        try {
            this.props = File.createTempFile(".jemmy.othervm.", ".properties");
            this.props.deleteOnExit();
            PrintWriter fw = new PrintWriter(this.props);
            for (Field f : AWTRobotInputFactory.class.getDeclaredFields()) {
                if ((f.getModifiers() & 0x10) == 0 || (f.getModifiers() & 8) == 0 || !f.getType().equals(String.class) || !f.getName().startsWith("OTHER_VM_") || Environment.getEnvironment().getProperty((String)f.get(null)) == null) continue;
                fw.println(f.get(null) + "=" + Environment.getEnvironment().getProperty((String)f.get(null)));
            }
            fw.close();
        }
        catch (IllegalArgumentException ex) {
            throw new JemmyException("Failed to create temporary properties file: " + this.props.getAbsolutePath(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new JemmyException("Failed to create temporary properties file: " + this.props.getAbsolutePath(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new JemmyException("Failed to create temporary properties file: " + this.props.getAbsolutePath(), (Throwable)ex);
        }
    }

    private void startServer() {
        try {
            this.prepareProperties();
            ProcessBuilder pb = new ProcessBuilder("java", "-cp", System.getProperty("java.class.path"), "-Djemmy.properties=" + this.props.getAbsolutePath(), RobotExecutor.class.getName(), Integer.toString(this.connectionPort));
            pb.redirectErrorStream(true);
            final Process p = pb.start();
            new Thread(){

                @Override
                public void run() {
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            System.out.println("SERVER: " + line);
                        }
                    }
                    catch (IOException ex) {
                        throw new JemmyException("Exception during other JVM output processing", (Throwable)ex);
                    }
                }
            }.start();
        }
        catch (IOException ex) {
            throw new JemmyException("Failed to start other JVM", (Throwable)ex);
        }
    }

    public void ensureConnection() {
        this.ensureInited();
        if (this.runInOtherJVM && !this.connectionEstablished) {
            this.initClientConnection();
        }
    }

    private void initClientConnection() {
        this.connectionHost = (String)Environment.getEnvironment().getProperty("awt.robot.othervm.host", (Object)"localhost");
        this.connectionPort = Integer.parseInt((String)Environment.getEnvironment().getProperty("awt.robot.othervm.port", (Object)"53669"));
        try {
            try {
                this.socket = new Socket(this.connectionHost, this.connectionPort);
            }
            catch (IOException ex) {
                if ("localhost".equalsIgnoreCase(this.connectionHost) || "127.0.0.1".equals(this.connectionHost)) {
                    this.startServer();
                    Environment.getEnvironment().getTimeout("");
                    Timeout waitTime = new Timeout("connection wait time", 300000L);
                    this.socket = (Socket)new Waiter(waitTime).ensureState((State)new State<Socket>(){
                        Exception ex;

                        public Socket reached() {
                            Socket socket = null;
                            try {
                                socket = new Socket(RobotExecutor.this.connectionHost, RobotExecutor.this.connectionPort);
                            }
                            catch (UnknownHostException ex1) {
                                this.ex = ex1;
                            }
                            catch (Exception ex1) {
                                this.ex = ex1;
                            }
                            return socket;
                        }

                        public String toString() {
                            if (this.ex != null) {
                                Logger.getLogger(RobotExecutor.class.getName()).log(Level.INFO, null, this.ex);
                            }
                            return "Waiting for connection to be established with other JVM (" + RobotExecutor.this.connectionHost + ":" + RobotExecutor.this.connectionPort + ", exception: " + this.ex + ")";
                        }
                    });
                }
                throw new JemmyException("Failed to establish socket connection with other JVM (" + this.connectionHost + ":" + this.connectionPort + ")", (Throwable)ex);
            }
            this.outputStream = new ObjectOutputStream(this.socket.getOutputStream());
            this.inputStream = new ObjectInputStream(this.socket.getInputStream());
            this.connectionEstablished = true;
            this.ready = true;
            System.out.println("Connection established!");
            this.setAutoDelay(this.autoDelay);
        }
        catch (IOException ex) {
            throw new JemmyException("Failed to establish socket connection with other JVM (" + this.connectionHost + ":" + this.connectionPort + ")", (Throwable)ex);
        }
    }

    public synchronized Object getProperty(String name) {
        this.ensureConnection();
        try {
            this.outputStream.writeObject("getProperty");
            this.outputStream.writeObject(name);
            Object result = this.inputStream.readObject();
            String response = (String)this.inputStream.readObject();
            if (!"OK".equals(response)) {
                throw new JemmyException("Remote operation didn't succeed");
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new JemmyException("Socket communication with other JVM failed", (Throwable)ex);
        }
        catch (OptionalDataException ex) {
            throw new JemmyException("Socket communication with other JVM failed: OptionalDataException eof = " + ex.eof + ", length = " + ex.length, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new JemmyException("Socket communication with other JVM failed", (Throwable)ex);
        }
    }

    private synchronized Object makeAnOperationRemotely(String method, Object[] params, Class[] paramClasses) {
        this.ensureConnection();
        try {
            Object result;
            this.outputStream.writeObject("makeAnOperation");
            this.outputStream.writeObject(method);
            this.outputStream.writeObject(params);
            this.outputStream.writeObject(paramClasses);
            String response = (String)this.inputStream.readObject();
            if ("image".equals(response)) {
                result = PNGDecoder.decode(this.inputStream, false);
            } else {
                if (!"OK".equals(response)) {
                    throw new JemmyException("Remote operation didn't succeed");
                }
                result = this.inputStream.readObject();
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new JemmyException("Socket communication with other JVM failed", (Throwable)ex);
        }
        catch (OptionalDataException ex) {
            throw new JemmyException("Socket communication with other JVM failed: OptionalDataException eof = " + ex.eof + ", length = " + ex.length, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new JemmyException("Socket communication with other JVM failed", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void server() {
        System.out.println("Robot ready!");
        System.out.flush();
        this.connectionPort = Integer.parseInt((String)Environment.getEnvironment().getProperty("awt.robot.othervm.port", (Object)"53669"));
        while (true) {
            ServerSocket sc;
            Thread watchdog = new Thread("RobotExecutor.server watchdog"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(CONNECTION_TIMEOUT);
                        System.out.println("Exiting server as there is no connection for " + (double)CONNECTION_TIMEOUT / 60000.0 + " minutes");
                        System.out.flush();
                        System.exit(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            watchdog.start();
            System.out.println("Waiting for incoming connection for up to " + (double)CONNECTION_TIMEOUT / 60000.0 + " minutes");
            try {
                sc = new ServerSocket(this.connectionPort);
                this.socket = sc.accept();
                watchdog.interrupt();
            }
            catch (IOException ex) {
                throw new JemmyException("Can't establish connection with client", (Throwable)ex);
            }
            System.out.println("Connection established!");
            try {
                try {
                    this.inputStream = new ObjectInputStream(this.socket.getInputStream());
                    this.outputStream = new ObjectOutputStream(this.socket.getOutputStream());
                    while (true) {
                        Class[] paramClasses;
                        Object[] params;
                        String command;
                        if ("exit".equals(command = (String)this.inputStream.readObject())) {
                            System.exit(0);
                        }
                        if ("getProperty".equals(command)) {
                            String property = (String)this.inputStream.readObject();
                            this.outputStream.writeObject(Environment.getEnvironment().getProperty(property));
                            this.outputStream.writeObject("OK");
                        }
                        if (!"makeAnOperation".equals(command)) continue;
                        String method = (String)this.inputStream.readObject();
                        Object result = this.makeAnOperationLocally(method, params = (Object[])this.inputStream.readObject(), paramClasses = (Class[])this.inputStream.readObject());
                        if (result instanceof BufferedImage) {
                            this.outputStream.writeObject("image");
                            BufferedImage image = (BufferedImage)BufferedImage.class.cast(result);
                            new PNGEncoder(this.outputStream, 2).encode(image, false);
                            continue;
                        }
                        this.outputStream.writeObject("OK");
                        this.outputStream.writeObject(result);
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new JemmyException("Socket communication with other JVM failed", (Throwable)ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(RobotExecutor.class.getName()).log(Level.SEVERE, null, ex);
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException ex2) {
                            Logger.getLogger(RobotExecutor.class.getName()).log(Level.SEVERE, "Exception during socket closing", ex2);
                        }
                    }
                    if (sc == null) continue;
                    try {
                        sc.close();
                    }
                    catch (IOException ex3) {
                        Logger.getLogger(RobotExecutor.class.getName()).log(Level.SEVERE, "Exception during server socket closing", ex3);
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(RobotExecutor.class.getName()).log(Level.SEVERE, "Exception during socket closing", ex);
                    }
                }
                if (sc != null) {
                    try {
                        sc.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(RobotExecutor.class.getName()).log(Level.SEVERE, "Exception during server socket closing", ex);
                    }
                }
                throw throwable;
            }
        }
    }

    private void initRobot() {
        if (EventQueue.isDispatchThread()) {
            this.doInitRobot();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        RobotExecutor.this.doInitRobot();
                    }
                });
            }
            catch (InterruptedException ex) {
                throw new JemmyException("Failed to initialize robot", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new JemmyException("Failed to initialize robot", (Throwable)ex);
            }
        }
    }

    private void doInitRobot() {
        try {
            ClassReference robotClassReverence = new ClassReference("java.awt.Robot");
            this.robotReference = new ClassReference(robotClassReverence.newInstance(null, null));
            if (this.awtMap == null) {
                this.awtMap = new AWTMap();
            }
            this.setAutoDelay(this.autoDelay);
            this.ready = true;
        }
        catch (InvocationTargetException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new JemmyException("Exception during java.awt.Robot accessing", (Throwable)e);
        }
    }

    protected void synchronizeRobot() {
        this.ensureInited();
        if (!this.runInOtherJVM && !EventQueue.isDispatchThread()) {
            if (this.robotReference == null) {
                this.initRobot();
            }
            try {
                this.robotReference.invokeMethod("waitForIdle", null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setAutoDelay(Timeout autoDelay) {
        this.autoDelay = autoDelay;
        if (this.ready) {
            this.makeAnOperation("setAutoDelay", new Object[]{new Integer((int)(autoDelay != null ? autoDelay.getValue() : 0L))}, new Class[]{Integer.TYPE});
        }
    }

    public boolean isRunInOtherJVM() {
        this.ensureInited();
        return this.runInOtherJVM;
    }

    public void setRunInOtherJVM(boolean runInOtherJVM) {
        if (this.inited && this.runInOtherJVM && this.connectionEstablished && !runInOtherJVM) {
            this.shutdownConnection();
        }
        this.runInOtherJVM = runInOtherJVM;
        this.inited = true;
        this.ready = false;
    }

    private void shutdownConnection() {
        try {
            this.outputStream.writeObject("exit");
            this.socket.close();
            this.connectionEstablished = false;
        }
        catch (IOException ex) {
            throw new JemmyException("Failed to shutdown connection", (Throwable)ex);
        }
    }

    static {
        CONNECTION_TIMEOUT = Integer.parseInt((String)Environment.getEnvironment().getProperty("awt.robot.othervm.connection.timeout", (Object)Integer.toString(900000)));
        convertables = new HashSet<String>(Arrays.asList("mousePress", "mouseRelease", "keyPress", "keyRelease"));
    }
}

