/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jemmy.JemmyException;
import org.jemmy.control.Wrap;
import org.jemmy.env.Timeout;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.MenuSelectable;
import org.jemmy.lookup.LookupCriteria;
import org.jemmy.resources.StringComparePolicy;
import org.jemmy.swt.ItemWrap;
import org.jemmy.swt.Shells;
import org.jemmy.swt.lookup.ByTextItem;
import org.jemmy.timing.State;

public class SWTMenu
implements MenuSelectable<MenuItem> {
    public static final Timeout BETWEEN_KEYS_SLEEP = new Timeout(SWTMenu.class.getName() + ".between.keys.timeout", 100L);
    public static final Timeout SUBMENU_WAIT_TIMEOUT = new Timeout(SWTMenu.class.getName() + ".submenu.wait.timeout", 1000L);
    public static final String SELECTION_BUTTON_PROP = SWTMenu.class.getName() + ".selection.button";
    public static final String ESCAPE_BUTTON_PROP = SWTMenu.class.getName() + ".escape.button";
    public static final String MULTI_LEVEL_DISCARD_PROP = SWTMenu.class.getName() + ".multi.level.discard";
    public static final String SKIPS_DISABLED_PROP = SWTMenu.class.getName() + ".skips.disabled";
    Wrap<? extends Control> owner;
    boolean isBar;
    private final Keyboard.KeyboardButton selectionButton;
    private final Keyboard.KeyboardButton escapeButton;
    private final boolean skipsDisabled;
    private final boolean multiLevelDiscard;

    public SWTMenu(Wrap<? extends Control> owner, boolean isBar) {
        this.owner = owner;
        this.isBar = isBar;
        Keyboard.KeyboardButtons defaultSelectionButton = System.getProperty("os.name").contains("Linux") ? Keyboard.KeyboardButtons.SPACE : Keyboard.KeyboardButtons.ENTER;
        Keyboard.KeyboardButtons defaultEscapeButton = Keyboard.KeyboardButtons.ESCAPE;
        Boolean defaultSkipsDisabled = System.getProperty("os.name").contains("Linux");
        Boolean defaultMultiLevelDiscard = System.getProperty("os.name").contains("Windows");
        this.selectionButton = (Keyboard.KeyboardButton)owner.getEnvironment().getProperty(Keyboard.KeyboardButton.class, (Object)SELECTION_BUTTON_PROP, (Object)defaultSelectionButton);
        this.escapeButton = (Keyboard.KeyboardButton)owner.getEnvironment().getProperty(Keyboard.KeyboardButton.class, (Object)ESCAPE_BUTTON_PROP, (Object)defaultEscapeButton);
        this.skipsDisabled = (Boolean)owner.getEnvironment().getProperty(Boolean.class, (Object)SKIPS_DISABLED_PROP, (Object)defaultSkipsDisabled);
        this.multiLevelDiscard = (Boolean)owner.getEnvironment().getProperty(Boolean.class, (Object)MULTI_LEVEL_DISCARD_PROP, (Object)defaultMultiLevelDiscard);
    }

    public void push(LookupCriteria<MenuItem> ... criteria) {
        this.select(criteria);
        this.owner.keyboard().pushKey(this.selectionButton);
        this.owner.getEnvironment().getTimeout(BETWEEN_KEYS_SLEEP).sleep();
    }

    public void push(boolean desiredSelectionState, LookupCriteria<MenuItem> ... criteria) {
        if (desiredSelectionState != this.getSelection(this.select(criteria))) {
            this.owner.keyboard().pushKey(this.selectionButton);
        } else {
            this.pushEscape(this.multiLevelDiscard ? criteria.length : 1);
        }
        this.owner.getEnvironment().getTimeout(BETWEEN_KEYS_SLEEP).sleep();
    }

    public boolean getState(LookupCriteria<MenuItem> ... criteria) {
        boolean result = this.getSelection(this.select(criteria));
        this.pushEscape(this.multiLevelDiscard ? criteria.length : 1);
        return result;
    }

    private void pushEscape(int times) {
        for (int i = 0; i < times; ++i) {
            this.owner.keyboard().pushKey(this.escapeButton);
            this.owner.getEnvironment().getTimeout(BETWEEN_KEYS_SLEEP).sleep();
        }
    }

    private boolean getSelection(Wrap<MenuItem> menuItem) {
        boolean[] result = new boolean[]{false};
        Display.getDefault().syncExec(() -> {
            result[0] = ((MenuItem)menuItem.getControl()).getSelection();
        });
        return result[0];
    }

    public Wrap<MenuItem> select(LookupCriteria<MenuItem> ... criteria) {
        if (criteria.length == 0) {
            throw new IllegalArgumentException("Menu path length should be greater than 0");
        }
        Menu[] start = new Menu[1];
        if (this.isBar) {
            if (!(this.owner.getControl() instanceof Shell)) {
                throw new JemmyException("Menu bars are in shells");
            }
            Display.getDefault().syncExec(() -> {
                start[0] = ((Shell)this.owner.getControl()).getMenuBar();
            });
        } else {
            Display.getDefault().syncExec(() -> {
                start[0] = ((Control)this.owner.getControl()).getMenu();
            });
        }
        return this.select(start[0], Arrays.asList(criteria), true);
    }

    private Wrap<MenuItem> select(Menu menu, List<LookupCriteria<MenuItem>> criteria, boolean entry) {
        this.waitVisible(menu);
        int[] moveTimes = new int[]{0};
        MenuItem[] current = new MenuItem[]{null};
        Display.getDefault().syncExec(() -> {
            for (MenuItem item : menu.getItems()) {
                if (((LookupCriteria)criteria.get(0)).check((Object)item)) {
                    current[0] = item;
                    break;
                }
                if (!item.isEnabled() && this.skipsDisabled || item.toString().contains("{|}")) continue;
                moveTimes[0] = moveTimes[0] + 1;
            }
        });
        if (current[0] == null) {
            throw new JemmyException("Unable to find menu item conforming criteria " + criteria.get(0).toString(), (Object)menu);
        }
        boolean horizontal = entry ? this.isBar : false;
        this.move(moveTimes[0], horizontal);
        if (criteria.size() > 1) {
            Menu[] nextMenu = new Menu[1];
            ArrayList<LookupCriteria<MenuItem>> nextCriteria = new ArrayList<LookupCriteria<MenuItem>>();
            nextCriteria.addAll(criteria);
            nextCriteria.remove(0);
            Keyboard.KeyboardButtons key = horizontal ? Keyboard.KeyboardButtons.DOWN : Keyboard.KeyboardButtons.RIGHT;
            this.owner.keyboard().pushKey((Keyboard.KeyboardButton)key);
            this.owner.getEnvironment().getTimeout(BETWEEN_KEYS_SLEEP).sleep();
            Display.getDefault().syncExec(() -> {
                nextMenu[0] = current[0].getMenu();
            });
            if (nextMenu[0] == null) {
                throw new JemmyException("No submenu while criteria list length is still " + criteria.size(), criteria.get(0));
            }
            return this.select(nextMenu[0], nextCriteria, false);
        }
        return new ItemWrap<MenuItem>(this.owner, current[0]);
    }

    void waitVisible(final Menu menu) {
        this.owner.getEnvironment().getWaiter(SUBMENU_WAIT_TIMEOUT).waitValue((Object)true, (State)new State<Boolean>(){
            boolean state = false;

            public Boolean reached() {
                Display.getDefault().syncExec(() -> {
                    this.state = menu.isVisible();
                });
                return this.state;
            }
        });
    }

    private void move(int moveTimes, boolean horizontal) {
        Keyboard.KeyboardButtons key = horizontal ? Keyboard.KeyboardButtons.RIGHT : Keyboard.KeyboardButtons.DOWN;
        for (int i = 0; i < moveTimes; ++i) {
            this.owner.keyboard().pushKey((Keyboard.KeyboardButton)key);
            this.owner.getEnvironment().getTimeout(BETWEEN_KEYS_SLEEP).sleep();
        }
    }

    static LookupCriteria<MenuItem> createCriteria(String text, StringComparePolicy policy) {
        return new ByTextItem<MenuItem>(text, policy);
    }

    static {
        Shells.SHELLS.getEnvironment().initTimeout(BETWEEN_KEYS_SLEEP);
        Shells.SHELLS.getEnvironment().initTimeout(SUBMENU_WAIT_TIMEOUT);
    }
}

