/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.client.block.util.BlockLocationUtils;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.network.TieredIdentityFactory;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.collect.Lists;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.TieredIdentity;
import alluxio.wire.WorkerNetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@ThreadSafe
public final class LocalFirstPolicy
implements BlockLocationPolicy {
    private final TieredIdentity mTieredIdentity;
    private final AlluxioConfiguration mConf;

    public LocalFirstPolicy(AlluxioConfiguration conf) {
        this.mTieredIdentity = TieredIdentityFactory.localIdentity(conf);
        this.mConf = conf;
    }

    static LocalFirstPolicy create(AlluxioConfiguration conf) {
        return new LocalFirstPolicy(conf);
    }

    @VisibleForTesting
    LocalFirstPolicy(TieredIdentity identity, AlluxioConfiguration conf) {
        this.mTieredIdentity = identity;
        this.mConf = conf;
    }

    @Override
    public WorkerNetAddress getWorker(GetWorkerOptions options) {
        ArrayList<BlockWorkerInfo> shuffledWorkers = Lists.newArrayList(options.getBlockWorkerInfos());
        Collections.shuffle(shuffledWorkers);
        List candidateWorkers = shuffledWorkers.stream().filter(worker -> worker.getCapacityBytes() >= options.getBlockInfo().getLength()).collect(Collectors.toList());
        List<WorkerNetAddress> addresses = candidateWorkers.stream().map(worker -> worker.getNetAddress()).filter(Objects::nonNull).collect(Collectors.toList());
        Optional<Pair<WorkerNetAddress, Boolean>> nearest = BlockLocationUtils.nearest(this.mTieredIdentity, addresses, this.mConf);
        if (!nearest.isPresent()) {
            return null;
        }
        return nearest.get().getFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalFirstPolicy)) {
            return false;
        }
        LocalFirstPolicy that = (LocalFirstPolicy)o;
        return Objects.equals(this.mTieredIdentity, that.mTieredIdentity);
    }

    public int hashCode() {
        return Objects.hash(this.mTieredIdentity);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("tieredIdentity", this.mTieredIdentity).toString();
    }
}

