/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.PageId;
import alluxio.client.quota.CacheScope;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.Objects;

@ThreadSafe
public class PageInfo {
    private final PageId mPageId;
    private final long mPageSize;
    private final CacheScope mCacheScope;

    public PageInfo(PageId pageId, long pageSize) {
        this(pageId, pageSize, CacheScope.GLOBAL);
    }

    public PageInfo(PageId pageId, long pageSize, CacheScope cacheScope) {
        this.mPageId = pageId;
        this.mPageSize = pageSize;
        this.mCacheScope = cacheScope;
    }

    public PageId getPageId() {
        return this.mPageId;
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    public CacheScope getScope() {
        return this.mCacheScope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageInfo pageInfo = (PageInfo)o;
        return this.mPageSize == pageInfo.mPageSize && Objects.equals(this.mPageId, pageInfo.mPageId) && this.mCacheScope == pageInfo.mCacheScope;
    }

    public int hashCode() {
        return Objects.hash(this.mPageId, this.mPageSize, this.mCacheScope);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("PageId", this.mPageId).add("PageSize", this.mPageSize).add("Scope", this.mCacheScope).toString();
    }
}

