/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.PropertyKey;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CredentialPropertyKeys {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialPropertyKeys.class);
    private static final Set<String> CREDENTIALS = CredentialPropertyKeys.findCredentialPropertyKeys("alluxio.conf.PropertyKey");

    protected static Set<String> findCredentialPropertyKeys(String propertyClass) {
        HashSet<String> credentials = new HashSet<String>();
        try {
            Field[] fields;
            Class<?> clazz = Class.forName(propertyClass);
            for (Field field : fields = clazz.getFields()) {
                PropertyKey tmp;
                if (field.getType() != PropertyKey.class || !Modifier.isStatic(field.getModifiers()) || (tmp = (PropertyKey)field.get(null)).getDisplayType() != PropertyKey.DisplayType.CREDENTIALS) continue;
                credentials.add(tmp.getName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            LOG.error("Failed to parse class alluxio.conf.PropertyKey", (Throwable)e);
        }
        return Collections.unmodifiableSet(credentials);
    }

    public static Set<String> getCredentials() {
        return CREDENTIALS;
    }
}

