/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf.path;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.conf.path.PathConfiguration;
import alluxio.shaded.client.com.google.common.collect.ImmutableMap;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public final class SpecificPathConfiguration
implements AlluxioConfiguration {
    private final AlluxioConfiguration mClusterConf;
    private final PathConfiguration mPathConf;
    private final AlluxioURI mPath;

    public SpecificPathConfiguration(AlluxioConfiguration clusterConf, PathConfiguration pathConf, AlluxioURI path) {
        this.mClusterConf = clusterConf;
        this.mPathConf = pathConf;
        this.mPath = path;
    }

    private AlluxioConfiguration conf(PropertyKey key) {
        return this.mPathConf.getConfiguration(this.mPath, key).orElse(this.mClusterConf);
    }

    @Override
    public Object get(PropertyKey key) {
        return this.conf(key).get(key);
    }

    @Override
    public Object get(PropertyKey key, ConfigurationValueOptions options) {
        return this.conf(key).get(key, options);
    }

    @Override
    public boolean isSet(PropertyKey key) {
        return this.conf(key).isSet(key);
    }

    @Override
    public boolean isSetByUser(PropertyKey key) {
        return this.conf(key).isSetByUser(key);
    }

    @Override
    public Set<PropertyKey> keySet() {
        return this.mClusterConf.keySet();
    }

    @Override
    public Set<PropertyKey> userKeySet() {
        return this.mPathConf.getPropertyKeys(this.mPath);
    }

    @Override
    public String getString(PropertyKey key) {
        return this.conf(key).getString(key);
    }

    @Override
    public int getInt(PropertyKey key) {
        return this.conf(key).getInt(key);
    }

    @Override
    public double getDouble(PropertyKey key) {
        return this.conf(key).getDouble(key);
    }

    @Override
    public boolean getBoolean(PropertyKey key) {
        return this.conf(key).getBoolean(key);
    }

    @Override
    public List<String> getList(PropertyKey key) {
        return this.conf(key).getList(key);
    }

    @Override
    public <T extends Enum<T>> T getEnum(PropertyKey key, Class<T> enumType) {
        return this.conf(key).getEnum(key, enumType);
    }

    @Override
    public long getBytes(PropertyKey key) {
        return this.conf(key).getBytes(key);
    }

    @Override
    public long getMs(PropertyKey key) {
        return this.conf(key).getMs(key);
    }

    @Override
    public Duration getDuration(PropertyKey key) {
        return this.conf(key).getDuration(key);
    }

    @Override
    public <T> Class<T> getClass(PropertyKey key) {
        return this.conf(key).getClass(key);
    }

    @Override
    public Map<String, Object> getNestedProperties(PropertyKey prefixKey) {
        return this.conf(prefixKey).getNestedProperties(prefixKey);
    }

    @Override
    public AlluxioProperties copyProperties() {
        AlluxioProperties properties = this.mClusterConf.copyProperties();
        for (PropertyKey key : this.keySet()) {
            this.mPathConf.getConfiguration(this.mPath, key).ifPresent(config -> properties.put(key, config.get(key), Source.PATH_DEFAULT));
        }
        return properties;
    }

    @Override
    public Source getSource(PropertyKey key) {
        return this.conf(key).getSource(key);
    }

    @Override
    public Map<String, Object> toMap(ConfigurationValueOptions opts) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        this.keySet().forEach(key -> map.put(key.getName(), this.conf((PropertyKey)key).getOrDefault((PropertyKey)key, null, opts)));
        return map.build();
    }

    @Override
    public void validate() {
        new InstancedConfiguration(this.copyProperties()).validate();
    }

    @Override
    public boolean clusterDefaultsLoaded() {
        return this.mClusterConf.clusterDefaultsLoaded();
    }
}

