/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclActions;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.AclEntryType;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.security.authorization.ExtendedACLEntries;
import alluxio.security.authorization.Mode;
import alluxio.shaded.client.com.fasterxml.jackson.core.JsonGenerator;
import alluxio.shaded.client.com.fasterxml.jackson.core.JsonParser;
import alluxio.shaded.client.com.fasterxml.jackson.core.JsonProcessingException;
import alluxio.shaded.client.com.fasterxml.jackson.databind.DeserializationContext;
import alluxio.shaded.client.com.fasterxml.jackson.databind.JsonNode;
import alluxio.shaded.client.com.fasterxml.jackson.databind.SerializerProvider;
import alluxio.shaded.client.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import alluxio.shaded.client.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import alluxio.shaded.client.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import alluxio.shaded.client.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@JsonSerialize(using=AccessControlListSerializer.class)
@JsonDeserialize(using=AccessControlListDeserializer.class)
@NotThreadSafe
public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = 106023217076996L;
    public static final AccessControlList EMPTY_ACL = new AccessControlList();
    public static final String OWNER_FIELD = "owner";
    public static final String OWNING_GROUP_FIELD = "owningGroup";
    public static final String STRING_ENTRY_FIELD = "stringEntries";
    public static final String OWNING_USER_KEY = "";
    public static final String OWNING_GROUP_KEY = "";
    protected String mOwningUser = "";
    protected String mOwningGroup = "";
    protected short mMode;
    protected ExtendedACLEntries mExtendedEntries;

    public AccessControlList() {
        this.clearEntries();
    }

    public void clearEntries() {
        this.mMode = 0;
        this.mExtendedEntries = null;
    }

    public ExtendedACLEntries getExtendedEntries() {
        return this.mExtendedEntries;
    }

    public String getOwningUser() {
        return this.mOwningUser;
    }

    public String getOwningGroup() {
        return this.mOwningGroup;
    }

    public AclActions getOwningUserActions() {
        return Mode.extractOwnerBits(this.mMode).toAclActions();
    }

    public AclActions getOwningGroupActions() {
        return Mode.extractGroupBits(this.mMode).toAclActions();
    }

    public AclActions getOtherActions() {
        return Mode.extractOtherBits(this.mMode).toAclActions();
    }

    public short getMode() {
        return this.mMode;
    }

    public List<AclEntry> getEntries() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add(new AclEntry.Builder().setType(AclEntryType.OWNING_USER).setSubject(this.mOwningUser).setActions(this.getOwningUserActions()).build());
        builder.add(new AclEntry.Builder().setType(AclEntryType.OWNING_GROUP).setSubject(this.mOwningGroup).setActions(this.getOwningGroupActions()).build());
        builder.add(new AclEntry.Builder().setType(AclEntryType.OTHER).setActions(this.getOtherActions()).build());
        if (this.hasExtended()) {
            builder.addAll(this.mExtendedEntries.getEntries());
        }
        return builder.build();
    }

    public boolean hasExtended() {
        return this.mExtendedEntries != null && this.mExtendedEntries.hasExtended();
    }

    public void removeEntry(AclEntry entry) {
        switch (entry.getType()) {
            case NAMED_USER: 
            case NAMED_GROUP: 
            case MASK: {
                if (this.mExtendedEntries != null) {
                    this.mExtendedEntries.removeEntry(entry);
                }
                return;
            }
            case OWNING_USER: 
            case OWNING_GROUP: 
            case OTHER: {
                throw new IllegalStateException("Deleting base entry is not allowed. entry: " + entry);
            }
        }
        throw new IllegalStateException("Unknown ACL entry type: " + (Object)((Object)entry.getType()));
    }

    public void removeExtendedEntries() {
        this.mExtendedEntries = null;
    }

    public void setOwningUser(String user) {
        Preconditions.checkNotNull(user);
        this.mOwningUser = user;
    }

    public void setOwningGroup(String group) {
        Preconditions.checkNotNull(group);
        this.mOwningGroup = group;
    }

    public void setMode(short mode) {
        this.mMode = mode;
    }

    public void updateMask() {
        if (this.hasExtended()) {
            AclActions actions = this.getOwningGroupActions();
            this.mExtendedEntries.updateMask(actions);
        }
    }

    public void setEntry(AclEntry entry) {
        switch (entry.getType()) {
            case NAMED_USER: 
            case NAMED_GROUP: 
            case MASK: {
                if (this.mExtendedEntries == null) {
                    this.mExtendedEntries = new ExtendedACLEntries();
                }
                this.mExtendedEntries.setEntry(entry);
                return;
            }
            case OWNING_USER: {
                Mode modeOwner = new Mode(this.mMode);
                modeOwner.setOwnerBits(entry.getActions().toModeBits());
                this.mMode = modeOwner.toShort();
                return;
            }
            case OWNING_GROUP: {
                Mode modeGroup = new Mode(this.mMode);
                modeGroup.setGroupBits(entry.getActions().toModeBits());
                this.mMode = modeGroup.toShort();
                return;
            }
            case OTHER: {
                Mode modeOther = new Mode(this.mMode);
                modeOther.setOtherBits(entry.getActions().toModeBits());
                this.mMode = modeOther.toShort();
                return;
            }
        }
        throw new IllegalStateException("Unknown ACL entry type: " + (Object)((Object)entry.getType()));
    }

    public boolean checkPermission(String user, List<String> groups, AclAction action) {
        return this.getPermission(user, groups).contains(action);
    }

    public AclActions getPermission(String user, List<String> groups) {
        AclActions actions;
        if (user.equals(this.mOwningUser)) {
            return new AclActions(this.getOwningUserActions());
        }
        if (this.hasExtended() && (actions = this.mExtendedEntries.getNamedUser(user)) != null) {
            AclActions result = new AclActions(actions);
            result.mask(this.mExtendedEntries.mMaskActions);
            return result;
        }
        boolean isGroupKnown = false;
        AclActions groupActions = new AclActions();
        if (groups.contains(this.mOwningGroup)) {
            isGroupKnown = true;
            groupActions.merge(this.getOwningGroupActions());
        }
        if (this.hasExtended()) {
            for (String group : groups) {
                AclActions actions2 = this.mExtendedEntries.getNamedGroup(group);
                if (actions2 == null) continue;
                isGroupKnown = true;
                groupActions.merge(actions2);
            }
        }
        if (isGroupKnown) {
            if (this.hasExtended()) {
                groupActions.mask(this.mExtendedEntries.mMaskActions);
            }
            return groupActions;
        }
        return this.getOtherActions();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessControlList that = (AccessControlList)o;
        boolean extendedNull = this.mExtendedEntries == null && that.mExtendedEntries == null;
        boolean extendedNotNull1 = this.mExtendedEntries != null && (this.mExtendedEntries.equals(that.mExtendedEntries) || !this.mExtendedEntries.hasExtended() && that.mExtendedEntries == null);
        boolean extendedNotNull2 = that.mExtendedEntries != null && (that.mExtendedEntries.equals(this.mExtendedEntries) || !that.mExtendedEntries.hasExtended() && this.mExtendedEntries == null);
        boolean extendedEquals = extendedNull || extendedNotNull1 || extendedNotNull2;
        return this.mOwningUser.equals(that.mOwningUser) && this.mOwningGroup.equals(that.mOwningGroup) && this.mMode == that.mMode && extendedEquals;
    }

    public int hashCode() {
        return Objects.hashCode(this.mOwningUser, this.mOwningGroup, this.mMode, this.mExtendedEntries);
    }

    public static AccessControlList fromStringEntries(String owner, String owningGroup, List<String> stringEntries) {
        AclEntry aclEntry;
        AccessControlList acl = stringEntries.size() > 0 ? ((aclEntry = AclEntry.fromCliString(stringEntries.get(0))).isDefault() ? new DefaultAccessControlList() : new AccessControlList()) : new DefaultAccessControlList();
        acl.setOwningUser(owner.intern());
        acl.setOwningGroup(owningGroup.intern());
        for (String stringEntry : stringEntries) {
            AclEntry aclEntry2 = AclEntry.fromCliString(stringEntry);
            acl.setEntry(aclEntry2);
        }
        return acl;
    }

    public List<String> toStringEntries() {
        ArrayList<String> entries = new ArrayList<String>();
        for (AclEntry entry : this.getEntries()) {
            entries.add(entry.toCliString());
        }
        return entries;
    }

    public String toString() {
        List<String> entries = this.toStringEntries();
        return String.join((CharSequence)",", entries);
    }

    public static class AccessControlListDeserializer
    extends StdDeserializer<AccessControlList> {
        private static final long serialVersionUID = 5524283318028333563L;

        public AccessControlListDeserializer() {
            super(AccessControlList.class);
        }

        @Override
        public AccessControlList deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            String owner = node.get(AccessControlList.OWNER_FIELD).asText().intern();
            String owningGroup = node.get(AccessControlList.OWNING_GROUP_FIELD).asText().intern();
            ArrayList<String> stringEntries = new ArrayList<String>();
            Iterator<JsonNode> nodeIterator = node.get(AccessControlList.STRING_ENTRY_FIELD).elements();
            while (nodeIterator.hasNext()) {
                stringEntries.add(nodeIterator.next().asText());
            }
            return AccessControlList.fromStringEntries(owner, owningGroup, stringEntries);
        }
    }

    public static class AccessControlListSerializer
    extends StdSerializer<AccessControlList> {
        private static final long serialVersionUID = -8523910728069876504L;

        public AccessControlListSerializer() {
            super(AccessControlList.class);
        }

        @Override
        public void serialize(AccessControlList accessControlList, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(AccessControlList.OWNER_FIELD, accessControlList.getOwningUser());
            jsonGenerator.writeStringField(AccessControlList.OWNING_GROUP_FIELD, accessControlList.getOwningGroup());
            jsonGenerator.writeObjectField(AccessControlList.STRING_ENTRY_FIELD, accessControlList.toStringEntries());
            jsonGenerator.writeEndObject();
        }
    }
}

