/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.google.common.collect;

import alluxio.shaded.client.com.google.common.annotations.GwtCompatible;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.AbstractIterator;
import alluxio.shaded.client.com.google.common.collect.ElementTypesAreNonnullByDefault;
import alluxio.shaded.client.javax.annotation.CheckForNull;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    public T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

