/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.zookeeper.common;

import alluxio.shaded.client.org.apache.zookeeper.common.FileKeyStoreLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JKSFileLoader
extends FileKeyStoreLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JKSFileLoader.class);
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final String JKS_KEY_STORE_TYPE = "JKS";

    private JKSFileLoader(String keyStorePath, String trustStorePath, String keyStorePassword, String trustStorePassword) {
        super(keyStorePath, trustStorePath, keyStorePassword, trustStorePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStore loadKeyStore() throws IOException, GeneralSecurityException {
        KeyStore ks = KeyStore.getInstance(JKS_KEY_STORE_TYPE);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(this.keyStorePath));
            ks.load(inputStream, this.passwordStringToCharArray(this.keyStorePassword));
            KeyStore keyStore = ks;
            this.forceClose(inputStream);
            return keyStore;
        }
        catch (Throwable throwable) {
            this.forceClose(inputStream);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStore loadTrustStore() throws IOException, GeneralSecurityException {
        KeyStore ts = KeyStore.getInstance(JKS_KEY_STORE_TYPE);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(this.trustStorePath));
            ts.load(inputStream, this.passwordStringToCharArray(this.trustStorePassword));
            KeyStore keyStore = ts;
            this.forceClose(inputStream);
            return keyStore;
        }
        catch (Throwable throwable) {
            this.forceClose(inputStream);
            throw throwable;
        }
    }

    private char[] passwordStringToCharArray(String password) {
        return password == null ? EMPTY_CHAR_ARRAY : password.toCharArray();
    }

    private void forceClose(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            LOG.info("Failed to close key store input stream", (Throwable)e);
        }
    }

    static class Builder
    extends FileKeyStoreLoader.Builder<JKSFileLoader> {
        Builder() {
        }

        @Override
        JKSFileLoader build() {
            return new JKSFileLoader(this.keyStorePath, this.trustStorePath, this.keyStorePassword, this.trustStorePassword);
        }
    }
}

