/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.executor;

import java.util.Comparator;
import java.util.PriorityQueue;

public class ControllableQueue<T> {
    private long mPastTime = 0L;
    private PriorityQueue<DelayNode<T>> mQueue = new PriorityQueue<DelayNode>(Comparator.comparing(DelayNode::getDelay));

    public boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    public T getHeadValue() {
        return this.mQueue.peek().getValue();
    }

    public long getHeadDelay() {
        return this.mQueue.peek().getDelay() - this.mPastTime;
    }

    public void add(long delay, T value) {
        this.mQueue.add(new DelayNode<T>(value, delay + this.mPastTime));
    }

    public void tick(long duration) {
        this.mPastTime += duration;
    }

    public T pop() {
        if (this.getHeadDelay() > 0L) {
            throw new IllegalStateException("cannot pop the head element when it has a non-zero delay");
        }
        return this.mQueue.poll().getValue();
    }

    public boolean remove(T element) {
        return this.mQueue.removeIf(x -> x.getValue() == element);
    }

    public String toString() {
        return "mPastTime=" + this.mPastTime + ", mQueue=" + this.mQueue.toString();
    }

    public static class DelayNode<T> {
        private final T mValue;
        private long mDelay;

        public DelayNode(T value, long millis) {
            this.mValue = value;
            this.mDelay = millis;
        }

        public T getValue() {
            return this.mValue;
        }

        public long getDelay() {
            return this.mDelay;
        }

        public void setDelay(long delay) {
            this.mDelay = delay;
        }
    }
}

