/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.AlluxioURI;
import alluxio.grpc.SyncPointStatus;

public class SyncPointInfo {
    private final AlluxioURI mSyncPointUri;
    private final SyncStatus mSyncStatus;

    public SyncPointInfo(AlluxioURI syncPoint, SyncStatus syncStatus) {
        this.mSyncPointUri = syncPoint;
        this.mSyncStatus = syncStatus;
    }

    public AlluxioURI getSyncPointUri() {
        return this.mSyncPointUri;
    }

    public SyncStatus getSyncStatus() {
        return this.mSyncStatus;
    }

    public alluxio.grpc.SyncPointInfo toProto() {
        SyncPointStatus status;
        switch (this.mSyncStatus) {
            case NOT_INITIALLY_SYNCED: {
                status = SyncPointStatus.Not_Initially_Synced;
                break;
            }
            case SYNCING: {
                status = SyncPointStatus.Syncing;
                break;
            }
            case INITIALLY_SYNCED: {
                status = SyncPointStatus.Initially_Synced;
                break;
            }
            default: {
                status = SyncPointStatus.Not_Initially_Synced;
            }
        }
        alluxio.grpc.SyncPointInfo info = alluxio.grpc.SyncPointInfo.newBuilder().setSyncPointUri(this.mSyncPointUri.getPath()).setSyncStatus(status).build();
        return info;
    }

    public static SyncPointInfo fromProto(alluxio.grpc.SyncPointInfo syncPointInfo) {
        SyncStatus syncStatus;
        switch (syncPointInfo.getSyncStatus()) {
            case Not_Initially_Synced: {
                syncStatus = SyncStatus.NOT_INITIALLY_SYNCED;
                break;
            }
            case Syncing: {
                syncStatus = SyncStatus.SYNCING;
                break;
            }
            case Initially_Synced: {
                syncStatus = SyncStatus.INITIALLY_SYNCED;
                break;
            }
            default: {
                syncStatus = SyncStatus.NOT_INITIALLY_SYNCED;
            }
        }
        return new SyncPointInfo(new AlluxioURI(syncPointInfo.getSyncPointUri()), syncStatus);
    }

    public static enum SyncStatus {
        NOT_INITIALLY_SYNCED,
        SYNCING,
        INITIALLY_SYNCED;

    }
}

