/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.cache;

import java.util.Date;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.client.AbstractClientResponse;
import org.apache.abdera.protocol.client.cache.Cache;
import org.apache.abdera.protocol.client.cache.CachedResponse;

public abstract class CachedResponseBase
extends AbstractClientResponse
implements CachedResponse {
    protected final Object key;
    protected final Cache cache;
    protected long initial_age;

    protected CachedResponseBase(Abdera abdera, Object key, Cache cache) {
        super(abdera);
        this.key = key;
        this.cache = cache;
    }

    private long calcInitialAge() {
        long age_value = this.getAge();
        long now = new Date().getTime();
        long cachedTime = this.getCachedTime();
        long date_value = cachedTime != -1L ? cachedTime : 0L;
        long apparent_age = Math.max(0L, now - date_value);
        long corrected_received_age = Math.max(apparent_age, age_value);
        return corrected_received_age / 1000L;
    }

    public Object getKey() {
        return this.key;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void release() {
        if (this.cache != null) {
            this.cache.remove(this.key);
        }
    }

    public long getInitialAge() {
        if (this.initial_age == -1L) {
            this.initial_age = this.calcInitialAge();
        }
        return this.initial_age;
    }

    public long getCachedTime() {
        return this.getServerDate().getTime();
    }

    public long getResidentAge() {
        long now = new Date().getTime();
        long init = this.getCachedTime();
        return Math.max(0L, now - init) / 1000L;
    }

    public long getCurrentAge() {
        return this.getInitialAge() + this.getResidentAge();
    }

    public long getFreshnessLifetime() {
        long lifetime = this.getMaxAge();
        if (lifetime == -1L) {
            Date expires_date = this.getExpires();
            long expires = expires_date != null ? expires_date.getTime() : -1L;
            long cachedTime = this.getCachedTime();
            if (expires != -1L) {
                lifetime = expires > cachedTime ? (expires - cachedTime) / 1000L : 0L;
            }
        }
        return lifetime;
    }

    public long getHowStale() {
        return !this.isFresh() ? this.getCurrentAge() - this.getFreshnessLifetime() : 0L;
    }

    public boolean isFresh() {
        long lifetime = this.getFreshnessLifetime();
        long currentage = this.getCurrentAge();
        return lifetime != -1L ? lifetime > currentage : true;
    }
}

