/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooUtil {
    public static final List<ACL> PRIVATE = new ArrayList<ACL>();
    public static final List<ACL> PUBLIC;

    public static void recursiveDelete(ZooKeeper zk, String zPath, int version, NodeMissingPolicy policy) throws KeeperException, InterruptedException {
        if (policy.equals((Object)NodeMissingPolicy.CREATE)) {
            throw new IllegalArgumentException(policy.name() + " is invalid for this operation");
        }
        try {
            for (String child : zk.getChildren(zPath, false)) {
                ZooUtil.recursiveDelete(zk, zPath + "/" + child, NodeMissingPolicy.SKIP);
            }
            Stat stat = zk.exists(zPath, null);
            if (stat != null) {
                zk.delete(zPath, stat.getVersion());
            }
        }
        catch (KeeperException e) {
            if (policy.equals((Object)NodeMissingPolicy.SKIP) && e.code().equals((Object)KeeperException.Code.NONODE)) {
                return;
            }
            throw e;
        }
    }

    public static void recursiveDelete(ZooKeeper zk, String zPath, NodeMissingPolicy policy) throws KeeperException, InterruptedException {
        ZooUtil.recursiveDelete(zk, zPath, -1, policy);
    }

    public static boolean putPersistentData(ZooKeeper zk, String zPath, byte[] data, NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putData(zk, zPath, data, CreateMode.PERSISTENT, -1, policy, PUBLIC);
    }

    public static boolean putPersistentData(ZooKeeper zk, String zPath, byte[] data, int version, NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putData(zk, zPath, data, CreateMode.PERSISTENT, version, policy, PUBLIC);
    }

    public static boolean putPersistentData(ZooKeeper zk, String zPath, byte[] data, int version, NodeExistsPolicy policy, List<ACL> acls) throws KeeperException, InterruptedException {
        return ZooUtil.putData(zk, zPath, data, CreateMode.PERSISTENT, version, policy, acls);
    }

    private static boolean putData(ZooKeeper zk, String zPath, byte[] data, CreateMode mode, int version, NodeExistsPolicy policy, List<ACL> acls) throws KeeperException, InterruptedException {
        if (policy == null) {
            policy = NodeExistsPolicy.FAIL;
        }
        block8: while (true) {
            try {
                zk.create(zPath, data, acls, mode);
                return true;
            }
            catch (KeeperException.NodeExistsException nee) {
                switch (policy) {
                    case SKIP: {
                        return false;
                    }
                    case OVERWRITE: {
                        try {
                            zk.setData(zPath, data, version);
                            return true;
                        }
                        catch (KeeperException.NoNodeException nne) {
                            continue block8;
                        }
                    }
                }
                throw nee;
            }
            break;
        }
    }

    public static byte[] getData(ZooKeeper zk, String zPath, Stat stat) throws KeeperException, InterruptedException {
        return zk.getData(zPath, false, stat);
    }

    public static Stat getStatus(ZooKeeper zk, String zPath) throws KeeperException, InterruptedException {
        return zk.exists(zPath, false);
    }

    public static boolean exists(ZooKeeper zk, String zPath) throws KeeperException, InterruptedException {
        return ZooUtil.getStatus(zk, zPath) != null;
    }

    public static void recursiveCopyPersistent(ZooKeeper zk, String source, String destination, NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        Stat stat = null;
        if (!ZooUtil.exists(zk, source)) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE, (String)source);
        }
        if (ZooUtil.exists(zk, destination)) {
            switch (policy) {
                case OVERWRITE: {
                    break;
                }
                case SKIP: {
                    return;
                }
                default: {
                    throw KeeperException.create((KeeperException.Code)KeeperException.Code.NODEEXISTS, (String)source);
                }
            }
        }
        stat = new Stat();
        byte[] data = zk.getData(source, false, stat);
        if (stat.getEphemeralOwner() == 0L) {
            if (data == null) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE, (String)source);
            }
            ZooUtil.putPersistentData(zk, destination, data, policy);
            if (stat.getNumChildren() > 0) {
                for (String child : zk.getChildren(source, false)) {
                    ZooUtil.recursiveCopyPersistent(zk, source + "/" + child, destination + "/" + child, policy);
                }
            }
        }
    }

    public static boolean putPrivatePersistentData(ZooKeeper zk, String zPath, byte[] data, NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putData(zk, zPath, data, CreateMode.PERSISTENT, -1, policy, PRIVATE);
    }

    public static String putPersistentSequential(ZooKeeper zk, String zPath, byte[] data) throws KeeperException, InterruptedException {
        return zk.create(zPath, data, PUBLIC, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public static String putEphemeralData(ZooKeeper zk, String zPath, byte[] data) throws KeeperException, InterruptedException {
        return zk.create(zPath, data, PUBLIC, CreateMode.EPHEMERAL);
    }

    public static String putEphemeralSequential(ZooKeeper zk, String zPath, byte[] data) throws KeeperException, InterruptedException {
        return zk.create(zPath, data, PUBLIC, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    public static byte[] getLockData(ZooCache zc, String path) {
        List<String> children = zc.getChildren(path);
        if (children == null || children.size() == 0) {
            return null;
        }
        children = new ArrayList<String>(children);
        Collections.sort(children);
        String lockNode = children.get(0);
        return zc.get(path + "/" + lockNode);
    }

    public static boolean isLockHeld(ZooKeeper zk, LockID lid) throws KeeperException, InterruptedException {
        while (true) {
            try {
                List children = zk.getChildren(lid.path, false);
                if (children.size() == 0) {
                    return false;
                }
                Collections.sort(children);
                String lockNode = (String)children.get(0);
                if (!lid.node.equals(lockNode)) {
                    return false;
                }
                Stat stat = zk.exists(lid.path + "/" + lid.node, false);
                return stat != null && stat.getEphemeralOwner() == lid.eid;
            }
            catch (KeeperException.ConnectionLossException ex) {
                UtilWaitThread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    static {
        PRIVATE.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
        PUBLIC = new ArrayList<ACL>();
        PUBLIC.addAll(PRIVATE);
        PUBLIC.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
    }

    public static class LockID {
        public long eid;
        public String path;
        public String node;

        public LockID(String root, String serializedLID) {
            String[] sa = serializedLID.split("\\$");
            int lastSlash = sa[0].lastIndexOf(47);
            if (sa.length != 2 || lastSlash < 0) {
                throw new IllegalArgumentException("Malformed serialized lock id " + serializedLID);
            }
            this.path = lastSlash == 0 ? root : root + "/" + sa[0].substring(0, lastSlash);
            this.node = sa[0].substring(lastSlash + 1);
            this.eid = new BigInteger(sa[1], 16).longValue();
        }

        public LockID(String path, String node, long eid) {
            this.path = path;
            this.node = node;
            this.eid = eid;
        }

        public String serialize(String root) {
            return this.path.substring(root.length()) + "/" + this.node + "$" + Long.toHexString(this.eid);
        }

        public String toString() {
            return " path = " + this.path + " node = " + this.node + " eid = " + Long.toHexString(this.eid);
        }
    }

    public static enum NodeMissingPolicy {
        SKIP,
        CREATE,
        FAIL;

    }

    public static enum NodeExistsPolicy {
        SKIP,
        OVERWRITE,
        FAIL;

    }
}

