/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate;

import java.io.Serializable;
import java.util.EnumSet;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.StackOverflowException;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.util.Daemon;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.log4j.Logger;

public class Fate<T> {
    private static final String DEBUG_PROP = "debug";
    private static final String AUTO_CLEAN_PROP = "autoClean";
    private static final String EXCEPTION_PROP = "exception";
    private static final String RETURN_PROP = "return";
    private static final Logger log = Logger.getLogger(Fate.class);
    private TStore<T> store;
    private T environment;
    private static final EnumSet<TStore.TStatus> FINISHED_STATES = EnumSet.of(TStore.TStatus.FAILED, TStore.TStatus.SUCCESSFUL, TStore.TStatus.UNKNOWN);

    public Fate(T environment, TStore<T> store, int numTreads) {
        this.store = store;
        this.environment = environment;
        for (int i = 0; i < numTreads; ++i) {
            Daemon thread = new Daemon(new LoggingRunnable(log, new TransactionRunner()), "Repo runner " + i);
            thread.start();
        }
    }

    public long startTransaction() {
        long dir = this.store.create();
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedTransaction(long tid, Repo<T> repo, boolean autoCleanUp) {
        block7: {
            this.store.reserve(tid);
            try {
                if (this.store.getStatus(tid) != TStore.TStatus.NEW) break block7;
                if (this.store.top(tid) == null) {
                    try {
                        this.store.push(tid, repo);
                    }
                    catch (StackOverflowException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (autoCleanUp) {
                    this.store.setProperty(tid, AUTO_CLEAN_PROP, Boolean.valueOf(autoCleanUp));
                }
                this.store.setProperty(tid, DEBUG_PROP, (Serializable)((Object)repo.getDescription()));
                this.store.setStatus(tid, TStore.TStatus.IN_PROGRESS);
            }
            finally {
                this.store.unreserve(tid, 0L);
            }
        }
    }

    public TStore.TStatus waitForCompletion(long tid) {
        return this.store.waitForStatusChange(tid, FINISHED_STATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(long tid) {
        this.store.reserve(tid);
        try {
            switch (this.store.getStatus(tid)) {
                case NEW: 
                case FAILED: 
                case SUCCESSFUL: {
                    this.store.delete(tid);
                    return;
                }
                case FAILED_IN_PROGRESS: 
                case IN_PROGRESS: {
                    throw new IllegalStateException("Can not delete in progress transaction " + String.format("%016x", tid));
                }
            }
            return;
        }
        finally {
            this.store.unreserve(tid, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReturn(long tid) {
        this.store.reserve(tid);
        try {
            if (this.store.getStatus(tid) != TStore.TStatus.SUCCESSFUL) {
                throw new IllegalStateException("Tried to get exception when transaction " + String.format("%016x", tid) + " not in successful state");
            }
            String string = (String)((Object)this.store.getProperty(tid, RETURN_PROP));
            return string;
        }
        finally {
            this.store.unreserve(tid, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getException(long tid) {
        this.store.reserve(tid);
        try {
            if (this.store.getStatus(tid) != TStore.TStatus.FAILED) {
                throw new IllegalStateException("Tried to get exception when transaction " + String.format("%016x", tid) + " not in failed state");
            }
            Exception exception = (Exception)this.store.getProperty(tid, EXCEPTION_PROP);
            return exception;
        }
        finally {
            this.store.unreserve(tid, 0L);
        }
    }

    private class TransactionRunner
    implements Runnable {
        private TransactionRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                long tid;
                long deferTime;
                block14: {
                    Repo<Object> prevOp;
                    Repo<Object> op;
                    block15: {
                        deferTime = 0L;
                        tid = Fate.this.store.reserve();
                        try {
                            TStore.TStatus status = Fate.this.store.getStatus(tid);
                            op = Fate.this.store.top(tid);
                            if (status == TStore.TStatus.FAILED_IN_PROGRESS) {
                                this.processFailed(tid, op);
                                break block14;
                            }
                            prevOp = null;
                            try {
                                deferTime = op.isReady(tid, Fate.this.environment);
                                if (deferTime == 0L) {
                                    prevOp = op;
                                    op = op.call(tid, Fate.this.environment);
                                    break block15;
                                }
                                Fate.this.store.unreserve(tid, deferTime);
                            }
                            catch (Exception e) {
                                this.transitionToFailed(tid, op, e);
                                Fate.this.store.unreserve(tid, deferTime);
                            }
                            continue;
                        }
                        catch (Throwable throwable) {
                            Fate.this.store.unreserve(tid, deferTime);
                            throw throwable;
                        }
                    }
                    if (op == null) {
                        String ret = prevOp.getReturn();
                        if (ret != null) {
                            Fate.this.store.setProperty(tid, Fate.RETURN_PROP, (Serializable)((Object)ret));
                        }
                        Fate.this.store.setStatus(tid, TStore.TStatus.SUCCESSFUL);
                        this.doCleanUp(tid);
                    } else {
                        try {
                            Fate.this.store.push(tid, op);
                        }
                        catch (StackOverflowException e) {
                            this.transitionToFailed(tid, op, e);
                            Fate.this.store.unreserve(tid, deferTime);
                            continue;
                        }
                    }
                }
                Fate.this.store.unreserve(tid, deferTime);
            }
        }

        private void transitionToFailed(long tid, Repo<T> op, Exception e) {
            String tidStr = String.format("%016x", tid);
            log.warn((Object)("Failed to execute Repo, tid=" + tidStr), (Throwable)e);
            Fate.this.store.setProperty(tid, Fate.EXCEPTION_PROP, e);
            Fate.this.store.setStatus(tid, TStore.TStatus.FAILED_IN_PROGRESS);
            log.info((Object)("Updated status for Repo with tid=" + tidStr + " to FAILED_IN_PROGRESS"));
        }

        private void processFailed(long tid, Repo<T> op) {
            while (op != null) {
                this.undo(tid, op);
                Fate.this.store.pop(tid);
                op = Fate.this.store.top(tid);
            }
            Fate.this.store.setStatus(tid, TStore.TStatus.FAILED);
            this.doCleanUp(tid);
        }

        private void doCleanUp(long tid) {
            Boolean autoClean = (Boolean)Fate.this.store.getProperty(tid, Fate.AUTO_CLEAN_PROP);
            if (autoClean != null && autoClean.booleanValue()) {
                Fate.this.store.delete(tid);
            } else {
                while (Fate.this.store.top(tid) != null) {
                    Fate.this.store.pop(tid);
                }
            }
        }

        private void undo(long tid, Repo<T> op) {
            try {
                op.undo(tid, Fate.this.environment);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to undo Repo, tid=" + String.format("%016x", tid)), (Throwable)e);
            }
        }
    }
}

