/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.fate.util.AddressUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZooSession {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Logger log = Logger.getLogger(ZooSession.class);
    private static Map<String, ZooSessionInfo> sessions = new HashMap<String, ZooSessionInfo>();

    private static String sessionKey(String keepers, int timeout, String scheme, byte[] auth) {
        return keepers + ":" + timeout + ":" + (scheme == null ? "" : scheme) + ":" + (auth == null ? "" : new String(auth, UTF8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZooKeeper connect(String host, int timeout, String scheme, byte[] auth, Watcher watcher) {
        int TIME_BETWEEN_CONNECT_CHECKS_MS = 100;
        int connectTimeWait = Math.min(10000, timeout);
        boolean tryAgain = true;
        long sleepTime = 100L;
        ZooKeeper zooKeeper = null;
        long startTime = System.currentTimeMillis();
        while (tryAgain) {
            try {
                zooKeeper = new ZooKeeper(host, timeout, watcher);
                for (int i = 0; i < connectTimeWait / 100 && tryAgain; ++i) {
                    if (zooKeeper.getState().equals((Object)ZooKeeper.States.CONNECTED)) {
                        if (auth != null) {
                            zooKeeper.addAuthInfo(scheme, auth);
                        }
                        tryAgain = false;
                        continue;
                    }
                    UtilWaitThread.sleep(100L);
                }
            }
            catch (IOException e) {
                if (e instanceof UnknownHostException) {
                    sleepTime = Math.max(sleepTime, (long)((AddressUtil.getAddressCacheNegativeTtl((UnknownHostException)e) + 1) * 1000));
                }
                log.warn((Object)("Connection to zooKeeper failed, will try again in " + String.format("%.2f secs", (double)sleepTime / 1000.0)), (Throwable)e);
            }
            finally {
                if (tryAgain && zooKeeper != null) {
                    try {
                        zooKeeper.close();
                        zooKeeper = null;
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)"interrupted", (Throwable)e);
                    }
                }
            }
            if (System.currentTimeMillis() - startTime > (long)(2 * timeout)) {
                throw new RuntimeException("Failed to connect to zookeeper (" + host + ") within 2x zookeeper timeout period " + timeout);
            }
            if (!tryAgain) continue;
            if (startTime + (long)(2 * timeout) < System.currentTimeMillis() + sleepTime + (long)connectTimeWait) {
                sleepTime = startTime + (long)(2 * timeout) - System.currentTimeMillis() - (long)connectTimeWait;
            }
            if (sleepTime < 0L) {
                connectTimeWait = (int)((long)connectTimeWait - sleepTime);
                sleepTime = 0L;
            }
            UtilWaitThread.sleep(sleepTime);
            if (sleepTime >= 10000L) continue;
            sleepTime += (long)((double)sleepTime * Math.random());
        }
        return zooKeeper;
    }

    public static synchronized ZooKeeper getSession(String zooKeepers, int timeout) {
        return ZooSession.getSession(zooKeepers, timeout, null, null);
    }

    public static synchronized ZooKeeper getSession(String zooKeepers, int timeout, String scheme, byte[] auth) {
        if (sessions == null) {
            throw new ZooSessionShutdownException();
        }
        String sessionKey = ZooSession.sessionKey(zooKeepers, timeout, scheme, auth);
        String readOnlySessionKey = ZooSession.sessionKey(zooKeepers, timeout, null, null);
        ZooSessionInfo zsi = sessions.get(sessionKey);
        if (zsi != null && zsi.zooKeeper.getState() == ZooKeeper.States.CLOSED) {
            if (auth != null && sessions.get(readOnlySessionKey) == zsi) {
                sessions.remove(readOnlySessionKey);
            }
            zsi = null;
            sessions.remove(sessionKey);
        }
        if (zsi == null) {
            ZooWatcher watcher = new ZooWatcher();
            log.debug((Object)("Connecting to " + zooKeepers + " with timeout " + timeout + " with auth"));
            zsi = new ZooSessionInfo(ZooSession.connect(zooKeepers, timeout, scheme, auth, watcher), watcher);
            sessions.put(sessionKey, zsi);
            if (auth != null && !sessions.containsKey(readOnlySessionKey)) {
                sessions.put(readOnlySessionKey, zsi);
            }
        }
        return zsi.zooKeeper;
    }

    public static synchronized void shutdown() {
        if (sessions == null) {
            return;
        }
        for (ZooSessionInfo zsi : sessions.values()) {
            try {
                zsi.zooKeeper.close();
            }
            catch (Exception e) {
                log.debug((Object)"Error closing zookeeper during shutdown", (Throwable)e);
            }
        }
        sessions = null;
    }

    private static class ZooWatcher
    implements Watcher {
        private ZooWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                log.debug((Object)("Session expired, state of current session : " + event.getState()));
            }
        }
    }

    private static class ZooSessionInfo {
        ZooKeeper zooKeeper;

        public ZooSessionInfo(ZooKeeper zooKeeper, ZooWatcher watcher) {
            this.zooKeeper = zooKeeper;
        }
    }

    public static class ZooSessionShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

