/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate;

import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.fate.ReadOnlyRepo;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.KeeperException;

public class AdminUtil<T> {
    private boolean exitOnError = false;

    public AdminUtil() {
        this(true);
    }

    public AdminUtil(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    public void print(ReadOnlyTStore<T> zs, IZooReaderWriter zk, String lockPath) throws KeeperException, InterruptedException {
        this.print(zs, zk, lockPath, new Formatter(System.out), null, null);
    }

    public void print(ReadOnlyTStore<T> zs, IZooReaderWriter zk, String lockPath, Formatter fmt, Set<Long> filterTxid, EnumSet<ReadOnlyTStore.TStatus> filterStatus) throws KeeperException, InterruptedException {
        HashMap<Long, ArrayList<String>> heldLocks = new HashMap<Long, ArrayList<String>>();
        HashMap waitingLocks = new HashMap();
        List<String> lockedIds = zk.getChildren(lockPath);
        for (String id : lockedIds) {
            try {
                List<String> lockNodes = zk.getChildren(lockPath + "/" + id);
                lockNodes = new ArrayList<String>(lockNodes);
                Collections.sort(lockNodes);
                int pos = 0;
                boolean bl = false;
                for (String node : lockNodes) {
                    try {
                        HashMap<Long, ArrayList<String>> locks;
                        ArrayList<String> tables;
                        byte[] data = zk.getData(lockPath + "/" + id + "/" + node, null);
                        String[] lda = new String(data, Charsets.UTF_8).split(":");
                        if (lda[0].charAt(0) == 'W') {
                            bl = true;
                        }
                        if ((tables = (ArrayList<String>)(locks = pos == 0 ? heldLocks : (lda[0].charAt(0) == 'R' && !bl ? heldLocks : waitingLocks)).get(Long.parseLong(lda[1], 16))) == null) {
                            tables = new ArrayList<String>();
                            locks.put(Long.parseLong(lda[1], 16), tables);
                        }
                        tables.add(lda[0].charAt(0) + ":" + id);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pos;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                fmt.format("Failed to read locks for %s continuing", id);
            }
        }
        List<Long> transactions = zs.list();
        long txCount = 0L;
        for (Long l : transactions) {
            List wlocks;
            zs.reserve(l);
            String debug = (String)((Object)zs.getProperty(l, "debug"));
            List hlocks = (List)heldLocks.remove(l);
            if (hlocks == null) {
                hlocks = Collections.emptyList();
            }
            if ((wlocks = (List)waitingLocks.remove(l)) == null) {
                wlocks = Collections.emptyList();
            }
            String top = null;
            ReadOnlyRepo<T> repo = zs.top(l);
            if (repo != null) {
                top = repo.getDescription();
            }
            ReadOnlyTStore.TStatus status = null;
            status = zs.getStatus(l);
            zs.unreserve(l, 0L);
            if (filterTxid != null && !filterTxid.contains(l) || filterStatus != null && !filterStatus.contains((Object)status)) continue;
            ++txCount;
            fmt.format("txid: %016x  status: %-18s  op: %-15s  locked: %-15s locking: %-15s top: %s%n", new Object[]{l, status, debug, hlocks, wlocks, top});
        }
        fmt.format(" %s transactions", txCount);
        if (heldLocks.size() != 0 || waitingLocks.size() != 0) {
            fmt.format("%nThe following locks did not have an associated FATE operation%n", new Object[0]);
            for (Map.Entry entry : heldLocks.entrySet()) {
                fmt.format("txid: %016x  locked: %s%n", entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : waitingLocks.entrySet()) {
                fmt.format("txid: %016x  locking: %s%n", entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean prepDelete(TStore<T> zs, IZooReaderWriter zk, String path, String txidStr) {
        long txid;
        if (!this.checkGlobalLock(zk, path)) {
            return false;
        }
        try {
            txid = Long.parseLong(txidStr, 16);
        }
        catch (NumberFormatException nfe) {
            System.out.printf("Invalid transaction ID format: %s%n", txidStr);
            return false;
        }
        boolean state = false;
        zs.reserve(txid);
        ReadOnlyTStore.TStatus ts = zs.getStatus(txid);
        switch (ts) {
            case UNKNOWN: {
                System.out.printf("Invalid transaction ID: %016x%n", txid);
                break;
            }
            case IN_PROGRESS: 
            case NEW: 
            case FAILED: 
            case FAILED_IN_PROGRESS: 
            case SUCCESSFUL: {
                System.out.printf("Deleting transaction: %016x (%s)%n", new Object[]{txid, ts});
                zs.delete(txid);
                state = true;
            }
        }
        zs.unreserve(txid, 0L);
        return state;
    }

    public boolean prepFail(TStore<T> zs, IZooReaderWriter zk, String path, String txidStr) {
        long txid;
        if (!this.checkGlobalLock(zk, path)) {
            return false;
        }
        try {
            txid = Long.parseLong(txidStr, 16);
        }
        catch (NumberFormatException nfe) {
            System.out.printf("Invalid transaction ID format: %s%n", txidStr);
            return false;
        }
        boolean state = false;
        zs.reserve(txid);
        ReadOnlyTStore.TStatus ts = zs.getStatus(txid);
        switch (ts) {
            case UNKNOWN: {
                System.out.printf("Invalid transaction ID: %016x%n", txid);
                break;
            }
            case IN_PROGRESS: 
            case NEW: {
                System.out.printf("Failing transaction: %016x (%s)%n", new Object[]{txid, ts});
                zs.setStatus(txid, ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS);
                state = true;
                break;
            }
            case SUCCESSFUL: {
                System.out.printf("Transaction already completed: %016x (%s)%n", new Object[]{txid, ts});
                break;
            }
            case FAILED: 
            case FAILED_IN_PROGRESS: {
                System.out.printf("Transaction already failed: %016x (%s)%n", new Object[]{txid, ts});
                state = true;
            }
        }
        zs.unreserve(txid, 0L);
        return state;
    }

    public void deleteLocks(TStore<T> zs, IZooReaderWriter zk, String path, String txidStr) throws KeeperException, InterruptedException {
        List<String> lockedIds = zk.getChildren(path);
        for (String id : lockedIds) {
            List<String> lockNodes = zk.getChildren(path + "/" + id);
            for (String node : lockNodes) {
                String lockPath = path + "/" + id + "/" + node;
                byte[] data = zk.getData(path + "/" + id + "/" + node, null);
                String[] lda = new String(data, Charsets.UTF_8).split(":");
                if (!lda[1].equals(txidStr)) continue;
                zk.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.SKIP);
            }
        }
    }

    public boolean checkGlobalLock(IZooReaderWriter zk, String path) {
        block6: {
            try {
                if (ZooLock.getLockData(zk.getZooKeeper(), path) == null) break block6;
                System.err.println("ERROR: Master lock is held, not running");
                if (this.exitOnError) {
                    System.exit(1);
                    break block6;
                }
                return false;
            }
            catch (KeeperException e) {
                System.err.println("ERROR: Could not read master lock, not running " + e.getMessage());
                if (this.exitOnError) {
                    System.exit(1);
                }
                return false;
            }
            catch (InterruptedException e) {
                System.err.println("ERROR: Could not read master lock, not running" + e.getMessage());
                if (this.exitOnError) {
                    System.exit(1);
                }
                return false;
            }
        }
        return true;
    }
}

