/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.security.SecurityPermission;
import java.util.Arrays;
import java.util.List;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.Retry;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooReaderWriter
extends ZooReader
implements IZooReaderWriter {
    private static final Logger log = Logger.getLogger(ZooReaderWriter.class);
    private static SecurityPermission ZOOWRITER_PERMISSION = new SecurityPermission("zookeeperWriterPermission");
    private static ZooReaderWriter instance = null;
    private final String scheme;
    private final byte[] auth;
    private final ZooUtil.ZooKeeperConnectionInfo info;

    @Override
    public ZooKeeper getZooKeeper() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ZOOWRITER_PERMISSION);
        }
        return this.getSession(this.keepers, this.timeout, this.scheme, this.auth);
    }

    public ZooReaderWriter(String string, int timeInMillis, String scheme, byte[] auth) {
        super(string, timeInMillis);
        this.scheme = scheme;
        this.auth = Arrays.copyOf(auth, auth.length);
        this.info = new ZooUtil.ZooKeeperConnectionInfo(string, timeInMillis, scheme, this.auth);
    }

    @Override
    public void recursiveDelete(String zPath, ZooUtil.NodeMissingPolicy policy) throws KeeperException, InterruptedException {
        ZooUtil.recursiveDelete(this.info, zPath, policy);
    }

    @Override
    public boolean putPersistentData(String zPath, byte[] data, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putPersistentData(this.info, zPath, data, policy);
    }

    @Override
    public boolean putPersistentData(String zPath, byte[] data, int version, ZooUtil.NodeExistsPolicy policy, List<ACL> acls) throws KeeperException, InterruptedException {
        return ZooUtil.putPersistentData(this.info, zPath, data, version, policy, acls);
    }

    @Override
    public boolean putPrivatePersistentData(String zPath, byte[] data, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putPrivatePersistentData(this.info, zPath, data, policy);
    }

    @Override
    public void putPersistentData(String zPath, byte[] data, int version, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        ZooUtil.putPersistentData(this.info, zPath, data, version, policy);
    }

    @Override
    public String putPersistentSequential(String zPath, byte[] data) throws KeeperException, InterruptedException {
        return ZooUtil.putPersistentSequential(this.info, zPath, data);
    }

    @Override
    public String putEphemeralData(String zPath, byte[] data) throws KeeperException, InterruptedException {
        return ZooUtil.putEphemeralData(this.info, zPath, data);
    }

    @Override
    public String putEphemeralSequential(String zPath, byte[] data) throws KeeperException, InterruptedException {
        return ZooUtil.putEphemeralSequential(this.info, zPath, data);
    }

    @Override
    public void recursiveCopyPersistent(String source, String destination, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        ZooUtil.recursiveCopyPersistent(this.info, source, destination, policy);
    }

    @Override
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        Retry retry = this.getRetryFactory().create();
        while (true) {
            try {
                this.getZooKeeper().delete(path, version);
                return;
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code == KeeperException.Code.NONODE) {
                    if (retry.hasRetried()) {
                        log.debug((Object)"Delete saw no node on a retry. Assuming node was deleted");
                        return;
                    }
                    throw e;
                }
                if (code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                this.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    @Override
    public byte[] mutate(String zPath, byte[] createValue, List<ACL> acl, IZooReaderWriter.Mutator mutator) throws Exception {
        Retry retry;
        if (createValue != null) {
            while (true) {
                retry = this.getRetryFactory().create();
                try {
                    this.getZooKeeper().create(zPath, createValue, acl, CreateMode.PERSISTENT);
                    return createValue;
                }
                catch (KeeperException ex) {
                    KeeperException.Code code = ex.code();
                    if (code == KeeperException.Code.NODEEXISTS) break;
                    if (code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.SESSIONEXPIRED) {
                        throw ex;
                    }
                    this.retryOrThrow(retry, ex);
                    retry.waitForNextAttempt();
                    continue;
                }
                break;
            }
        }
        while (true) {
            retry = this.getRetryFactory().create();
            Stat stat = new Stat();
            byte[] data = this.getData(zPath, false, stat);
            if ((data = mutator.mutate(data)) == null) {
                return data;
            }
            try {
                this.getZooKeeper().setData(zPath, data, stat.getVersion());
                return data;
            }
            catch (KeeperException ex) {
                KeeperException.Code code = ex.code();
                if (code == KeeperException.Code.BADVERSION) continue;
                if (code == KeeperException.Code.OPERATIONTIMEOUT || code == KeeperException.Code.CONNECTIONLOSS || code == KeeperException.Code.SESSIONEXPIRED) {
                    this.retryOrThrow(retry, ex);
                    retry.waitForNextAttempt();
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    public static synchronized ZooReaderWriter getInstance(String zookeepers, int timeInMillis, String scheme, byte[] auth) {
        if (instance == null) {
            instance = new ZooReaderWriter(zookeepers, timeInMillis, scheme, auth);
        }
        return instance;
    }

    @Override
    public boolean isLockHeld(ZooUtil.LockID lockID) throws KeeperException, InterruptedException {
        return ZooUtil.isLockHeld(this.info, lockID);
    }

    @Override
    public void mkdirs(String path) throws KeeperException, InterruptedException {
        if (path.equals("")) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path + "does not start with /");
        }
        if (this.exists(path)) {
            return;
        }
        String parent = path.substring(0, path.lastIndexOf("/"));
        this.mkdirs(parent);
        this.putPersistentData(path, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
    }
}

