/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.fate.zookeeper.Retry;
import org.apache.accumulo.fate.zookeeper.RetryFactory;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooSession;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooUtil {
    private static final Logger log = Logger.getLogger(ZooUtil.class);
    public static final List<ACL> PRIVATE = new ArrayList<ACL>();
    public static final List<ACL> PUBLIC;
    private static final RetryFactory RETRY_FACTORY;

    protected static ZooKeeper getZooKeeper(ZooKeeperConnectionInfo info) {
        return ZooUtil.getZooKeeper(info.keepers, info.timeout, info.scheme, info.auth);
    }

    protected static ZooKeeper getZooKeeper(String keepers, int timeout, String scheme, byte[] auth) {
        return ZooSession.getSession(keepers, timeout, scheme, auth);
    }

    protected static void retryOrThrow(Retry retry, KeeperException e) throws KeeperException {
        log.warn((Object)"Saw (possibly) transient exception communicating with ZooKeeper", (Throwable)e);
        if (retry.canRetry()) {
            retry.useRetry();
            return;
        }
        log.error((Object)("Retry attempts (" + retry.retriesCompleted() + ") exceeded trying to communicate with ZooKeeper"));
        throw e;
    }

    static void recursiveDelete(ZooKeeperConnectionInfo info, String zPath, NodeMissingPolicy policy) throws KeeperException, InterruptedException {
        List children;
        if (policy.equals((Object)NodeMissingPolicy.CREATE)) {
            throw new IllegalArgumentException(policy.name() + " is invalid for this operation");
        }
        Retry retry = RETRY_FACTORY.create();
        while (true) {
            try {
                children = ZooUtil.getZooKeeper(info).getChildren(zPath, false);
            }
            catch (KeeperException e) {
                KeeperException.Code c = e.code();
                if (c != KeeperException.Code.CONNECTIONLOSS && c != KeeperException.Code.OPERATIONTIMEOUT && c != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                ZooUtil.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
        for (String child : children) {
            ZooUtil.recursiveDelete(info, zPath + "/" + child, NodeMissingPolicy.SKIP);
        }
        while (true) {
            try {
                Stat stat = ZooUtil.getZooKeeper(info).exists(zPath, null);
                if (stat != null) {
                    try {
                        ZooUtil.getZooKeeper(info).delete(zPath, -1);
                        return;
                    }
                    catch (KeeperException.NoNodeException e) {
                        if (policy.equals((Object)NodeMissingPolicy.SKIP)) {
                            return;
                        }
                        throw e;
                    }
                }
                return;
            }
            catch (KeeperException e) {
                try {
                    KeeperException.Code c = e.code();
                    if (c != KeeperException.Code.CONNECTIONLOSS && c != KeeperException.Code.OPERATIONTIMEOUT && c != KeeperException.Code.SESSIONEXPIRED) {
                        throw e;
                    }
                    ZooUtil.retryOrThrow(retry, e);
                    retry.waitForNextAttempt();
                    continue;
                }
                catch (KeeperException e2) {
                    if (policy.equals((Object)NodeMissingPolicy.SKIP) && e2.code().equals((Object)KeeperException.Code.NONODE)) {
                        return;
                    }
                    throw e2;
                }
            }
            break;
        }
    }

    public static boolean putPersistentData(ZooKeeperConnectionInfo info, String zPath, byte[] data, NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putData(info, zPath, data, CreateMode.PERSISTENT, -1, policy, PUBLIC);
    }

    public static boolean putPersistentData(ZooKeeperConnectionInfo info, String zPath, byte[] data, int version, NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putData(info, zPath, data, CreateMode.PERSISTENT, version, policy, PUBLIC);
    }

    public static boolean putPersistentData(ZooKeeperConnectionInfo info, String zPath, byte[] data, int version, NodeExistsPolicy policy, List<ACL> acls) throws KeeperException, InterruptedException {
        return ZooUtil.putData(info, zPath, data, CreateMode.PERSISTENT, version, policy, acls);
    }

    private static boolean putData(ZooKeeperConnectionInfo info, String zPath, byte[] data, CreateMode mode, int version, NodeExistsPolicy policy, List<ACL> acls) throws KeeperException, InterruptedException {
        if (policy == null) {
            policy = NodeExistsPolicy.FAIL;
        }
        Retry retry = RETRY_FACTORY.create();
        block8: while (true) {
            try {
                ZooUtil.getZooKeeper(info).create(zPath, data, acls, mode);
                return true;
            }
            catch (KeeperException e) {
                block14: {
                    KeeperException.Code code = e.code();
                    if (code == KeeperException.Code.NODEEXISTS) {
                        switch (policy) {
                            case SKIP: {
                                return false;
                            }
                            case OVERWRITE: {
                                try {
                                    ZooUtil.getZooKeeper(info).setData(zPath, data, version);
                                    return true;
                                }
                                catch (KeeperException e2) {
                                    KeeperException.Code code2 = e2.code();
                                    if (code2 == KeeperException.Code.NONODE) continue block8;
                                    if (code2 == KeeperException.Code.CONNECTIONLOSS || code2 == KeeperException.Code.OPERATIONTIMEOUT || code2 == KeeperException.Code.SESSIONEXPIRED) {
                                        ZooUtil.retryOrThrow(retry, e2);
                                        break block14;
                                    }
                                    throw e2;
                                }
                            }
                            default: {
                                throw e;
                            }
                        }
                    }
                    if (code == KeeperException.Code.CONNECTIONLOSS || code == KeeperException.Code.OPERATIONTIMEOUT || code == KeeperException.Code.SESSIONEXPIRED) {
                        ZooUtil.retryOrThrow(retry, e);
                    } else {
                        throw e;
                    }
                }
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    public static byte[] getData(ZooKeeperConnectionInfo info, String zPath, Stat stat) throws KeeperException, InterruptedException {
        Retry retry = RETRY_FACTORY.create();
        while (true) {
            try {
                return ZooUtil.getZooKeeper(info).getData(zPath, false, stat);
            }
            catch (KeeperException e) {
                KeeperException.Code c = e.code();
                if (c != KeeperException.Code.CONNECTIONLOSS && c != KeeperException.Code.OPERATIONTIMEOUT && c != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                ZooUtil.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    public static Stat getStatus(ZooKeeperConnectionInfo info, String zPath) throws KeeperException, InterruptedException {
        Retry retry = RETRY_FACTORY.create();
        while (true) {
            try {
                return ZooUtil.getZooKeeper(info).exists(zPath, false);
            }
            catch (KeeperException e) {
                KeeperException.Code c = e.code();
                if (c != KeeperException.Code.CONNECTIONLOSS && c != KeeperException.Code.OPERATIONTIMEOUT && c != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                ZooUtil.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    public static boolean exists(ZooKeeperConnectionInfo info, String zPath) throws KeeperException, InterruptedException {
        return ZooUtil.getStatus(info, zPath) != null;
    }

    public static void recursiveCopyPersistent(ZooKeeperConnectionInfo info, String source, String destination, NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        Stat stat = null;
        if (!ZooUtil.exists(info, source)) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE, (String)source);
        }
        if (ZooUtil.exists(info, destination)) {
            switch (policy) {
                case OVERWRITE: {
                    break;
                }
                case SKIP: {
                    return;
                }
                default: {
                    throw KeeperException.create((KeeperException.Code)KeeperException.Code.NODEEXISTS, (String)source);
                }
            }
        }
        stat = new Stat();
        byte[] data = ZooUtil.getData(info, source, stat);
        if (stat.getEphemeralOwner() == 0L) {
            if (data == null) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE, (String)source);
            }
            ZooUtil.putPersistentData(info, destination, data, policy);
            if (stat.getNumChildren() > 0) {
                List children;
                Retry retry = RETRY_FACTORY.create();
                while (true) {
                    try {
                        children = ZooUtil.getZooKeeper(info).getChildren(source, false);
                    }
                    catch (KeeperException e) {
                        KeeperException.Code c = e.code();
                        if (c != KeeperException.Code.CONNECTIONLOSS && c != KeeperException.Code.OPERATIONTIMEOUT && c != KeeperException.Code.SESSIONEXPIRED) {
                            throw e;
                        }
                        ZooUtil.retryOrThrow(retry, e);
                        retry.waitForNextAttempt();
                        continue;
                    }
                    break;
                }
                for (String child : children) {
                    ZooUtil.recursiveCopyPersistent(info, source + "/" + child, destination + "/" + child, policy);
                }
            }
        }
    }

    public static boolean putPrivatePersistentData(ZooKeeperConnectionInfo info, String zPath, byte[] data, NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putData(info, zPath, data, CreateMode.PERSISTENT, -1, policy, PRIVATE);
    }

    public static String putPersistentSequential(ZooKeeperConnectionInfo info, String zPath, byte[] data) throws KeeperException, InterruptedException {
        Retry retry = RETRY_FACTORY.create();
        while (true) {
            try {
                return ZooUtil.getZooKeeper(info).create(zPath, data, PUBLIC, CreateMode.PERSISTENT_SEQUENTIAL);
            }
            catch (KeeperException e) {
                KeeperException.Code c = e.code();
                if (c != KeeperException.Code.CONNECTIONLOSS && c != KeeperException.Code.OPERATIONTIMEOUT && c != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                ZooUtil.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    public static String putEphemeralData(ZooKeeperConnectionInfo info, String zPath, byte[] data) throws KeeperException, InterruptedException {
        Retry retry = RETRY_FACTORY.create();
        while (true) {
            try {
                return ZooUtil.getZooKeeper(info).create(zPath, data, PUBLIC, CreateMode.EPHEMERAL);
            }
            catch (KeeperException e) {
                KeeperException.Code c = e.code();
                if (c != KeeperException.Code.CONNECTIONLOSS && c != KeeperException.Code.OPERATIONTIMEOUT && c != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                ZooUtil.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    public static String putEphemeralSequential(ZooKeeperConnectionInfo info, String zPath, byte[] data) throws KeeperException, InterruptedException {
        Retry retry = RETRY_FACTORY.create();
        while (true) {
            try {
                return ZooUtil.getZooKeeper(info).create(zPath, data, PUBLIC, CreateMode.EPHEMERAL_SEQUENTIAL);
            }
            catch (KeeperException e) {
                KeeperException.Code c = e.code();
                if (c != KeeperException.Code.CONNECTIONLOSS && c != KeeperException.Code.OPERATIONTIMEOUT && c != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                ZooUtil.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    public static byte[] getLockData(ZooCache zc, String path) {
        List<String> children = zc.getChildren(path);
        if (children == null || children.size() == 0) {
            return null;
        }
        children = new ArrayList<String>(children);
        Collections.sort(children);
        String lockNode = children.get(0);
        return zc.get(path + "/" + lockNode);
    }

    public static boolean isLockHeld(ZooKeeperConnectionInfo info, LockID lid) throws KeeperException, InterruptedException {
        Retry retry = RETRY_FACTORY.create();
        while (true) {
            try {
                List children = ZooUtil.getZooKeeper(info).getChildren(lid.path, false);
                if (children.size() == 0) {
                    return false;
                }
                Collections.sort(children);
                String lockNode = (String)children.get(0);
                if (!lid.node.equals(lockNode)) {
                    return false;
                }
                Stat stat = ZooUtil.getZooKeeper(info).exists(lid.path + "/" + lid.node, false);
                return stat != null && stat.getEphemeralOwner() == lid.eid;
            }
            catch (KeeperException ex) {
                KeeperException.Code c = ex.code();
                if (c == KeeperException.Code.CONNECTIONLOSS || c == KeeperException.Code.OPERATIONTIMEOUT || c == KeeperException.Code.SESSIONEXPIRED) {
                    ZooUtil.retryOrThrow(retry, ex);
                }
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    static {
        PRIVATE.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
        PUBLIC = new ArrayList<ACL>();
        PUBLIC.addAll(PRIVATE);
        PUBLIC.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
        RETRY_FACTORY = RetryFactory.DEFAULT_INSTANCE;
    }

    protected static class ZooKeeperConnectionInfo {
        String keepers;
        String scheme;
        int timeout;
        byte[] auth;

        public ZooKeeperConnectionInfo(String keepers, int timeout, String scheme, byte[] auth) {
            Preconditions.checkNotNull((Object)keepers);
            this.keepers = keepers;
            this.timeout = timeout;
            this.scheme = scheme;
            this.auth = auth;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder(31, 47);
            hcb.append((Object)this.keepers).append(this.timeout);
            if (null != this.scheme) {
                hcb.append((Object)this.scheme);
            }
            if (null != this.auth) {
                hcb.append(this.auth);
            }
            return hcb.toHashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ZooKeeperConnectionInfo) {
                ZooKeeperConnectionInfo other = (ZooKeeperConnectionInfo)o;
                if (!this.keepers.equals(other.keepers) || this.timeout != other.timeout) {
                    return false;
                }
                if (null != this.scheme) {
                    if (null == other.scheme) {
                        return false;
                    }
                    if (!this.scheme.equals(other.scheme)) {
                        return false;
                    }
                }
                if (null != this.auth) {
                    if (null == other.auth) {
                        return false;
                    }
                    if (!Arrays.equals(this.auth, other.auth)) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("zookeepers=").append(this.keepers);
            sb.append(", timeout=").append(this.timeout);
            sb.append(", scheme=").append(this.scheme);
            sb.append(", auth=").append(null == this.auth ? "null" : "REDACTED");
            return sb.toString();
        }
    }

    public static class LockID {
        public long eid;
        public String path;
        public String node;

        public LockID(String root, String serializedLID) {
            String[] sa = serializedLID.split("\\$");
            int lastSlash = sa[0].lastIndexOf(47);
            if (sa.length != 2 || lastSlash < 0) {
                throw new IllegalArgumentException("Malformed serialized lock id " + serializedLID);
            }
            this.path = lastSlash == 0 ? root : root + "/" + sa[0].substring(0, lastSlash);
            this.node = sa[0].substring(lastSlash + 1);
            this.eid = new BigInteger(sa[1], 16).longValue();
        }

        public LockID(String path, String node, long eid) {
            this.path = path;
            this.node = node;
            this.eid = eid;
        }

        public String serialize(String root) {
            return this.path.substring(root.length()) + "/" + this.node + "$" + Long.toHexString(this.eid);
        }

        public String toString() {
            return " path = " + this.path + " node = " + this.node + " eid = " + Long.toHexString(this.eid);
        }
    }

    public static enum NodeMissingPolicy {
        SKIP,
        CREATE,
        FAIL;

    }

    public static enum NodeExistsPolicy {
        SKIP,
        OVERWRITE,
        FAIL;

    }
}

