/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.https;

import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ssl.ServletSSL;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Krb5AndCertsSslSocketConnector
extends SslSocketConnector {
    public static final List<String> KRB5_CIPHER_SUITES = Collections.unmodifiableList(Collections.singletonList("TLS_KRB5_WITH_3DES_EDE_CBC_SHA"));
    private static final Logger LOG;
    private static final String REMOTE_PRINCIPAL = "remote_principal";
    private boolean useKrb = false;
    private boolean useCerts = true;

    public Krb5AndCertsSslSocketConnector() {
        this.setPasswords();
    }

    public static boolean isKrb(String mode) {
        return mode == MODE.KRB.toString() || mode == MODE.BOTH.toString();
    }

    public void setMode(String mode) {
        this.useKrb = mode == MODE.KRB.toString() || mode == MODE.BOTH.toString();
        this.useCerts = mode == MODE.CERTS.toString() || mode == MODE.BOTH.toString();
        this.logIfDebug("useKerb = " + this.useKrb + ", useCerts = " + this.useCerts);
    }

    private void setPasswords() {
        if (!this.useCerts) {
            Random r = new Random();
            System.setProperty("jetty.ssl.password", String.valueOf(r.nextLong()));
            System.setProperty("jetty.ssl.keypassword", String.valueOf(r.nextLong()));
        }
    }

    public SslContextFactory getSslContextFactory() {
        SslContextFactory factory = super.getSslContextFactory();
        if (this.useCerts) {
            return factory;
        }
        try {
            SSLContext context = factory.getProvider() == null ? SSLContext.getInstance(factory.getProtocol()) : SSLContext.getInstance(factory.getProtocol(), factory.getProvider());
            context.init(null, null, null);
            factory.setSslContext(context);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (NoSuchProviderException e) {
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
        return factory;
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        this.logIfDebug("Creating new KrbServerSocket for: " + host);
        SSLServerSocket ss = null;
        if (this.useCerts) {
            ss = (SSLServerSocket)super.newServerSocket(host, port, backlog);
        } else {
            try {
                ss = (SSLServerSocket)super.newServerSocket(host, port, backlog);
            }
            catch (Exception e) {
                LOG.warn("Could not create KRB5 Listener", e);
                throw new IOException("Could not create KRB5 Listener: " + e.toString());
            }
        }
        if (this.useKrb) {
            String[] combined;
            ss.setNeedClientAuth(true);
            if (this.useCerts) {
                String[] certs = ss.getEnabledCipherSuites();
                combined = new String[certs.length + KRB5_CIPHER_SUITES.size()];
                System.arraycopy(certs, 0, combined, 0, certs.length);
                System.arraycopy(KRB5_CIPHER_SUITES.toArray(new String[0]), 0, combined, certs.length, KRB5_CIPHER_SUITES.size());
            } else {
                combined = KRB5_CIPHER_SUITES.toArray(new String[0]);
            }
            ss.setEnabledCipherSuites(combined);
        }
        return ss;
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        if (this.useKrb) {
            SSLSocket sslSocket = (SSLSocket)endpoint.getTransport();
            Principal remotePrincipal = sslSocket.getSession().getPeerPrincipal();
            this.logIfDebug("Remote principal = " + remotePrincipal);
            request.setScheme("https");
            request.setAttribute(REMOTE_PRINCIPAL, (Object)remotePrincipal);
            if (!this.useCerts) {
                String cipherSuite = sslSocket.getSession().getCipherSuite();
                Integer keySize = ServletSSL.deduceKeyLength((String)cipherSuite);
                request.setAttribute("javax.servlet.request.cipher_suite", (Object)cipherSuite);
                request.setAttribute("javax.servlet.request.key_size", (Object)keySize);
            }
        }
        if (this.useCerts) {
            super.customize(endpoint, request);
        }
    }

    private void logIfDebug(String s) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(s);
        }
    }

    static {
        System.setProperty("https.cipherSuites", KRB5_CIPHER_SUITES.get(0));
        LOG = LoggerFactory.getLogger(Krb5AndCertsSslSocketConnector.class);
    }

    public static enum MODE {
        KRB,
        CERTS,
        BOTH;

    }
}

