/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultPropertiesResolver
implements PropertiesResolver {
    private final PropertiesComponent propertiesComponent;

    public DefaultPropertiesResolver(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    @Override
    public Properties resolveProperties(CamelContext context, boolean ignoreMissingLocation, String ... uri) throws Exception {
        Properties answer = new Properties();
        for (String path : uri) {
            Properties prop;
            if (path.startsWith("ref:")) {
                prop = this.loadPropertiesFromRegistry(context, ignoreMissingLocation, path);
                prop = this.prepareLoadedProperties(prop);
                answer.putAll((Map<?, ?>)prop);
                continue;
            }
            if (path.startsWith("file:")) {
                prop = this.loadPropertiesFromFilePath(context, ignoreMissingLocation, path);
                prop = this.prepareLoadedProperties(prop);
                answer.putAll((Map<?, ?>)prop);
                continue;
            }
            prop = this.loadPropertiesFromClasspath(context, ignoreMissingLocation, path);
            prop = this.prepareLoadedProperties(prop);
            answer.putAll((Map<?, ?>)prop);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadPropertiesFromFilePath(CamelContext context, boolean ignoreMissingLocation, String path) throws IOException {
        BufferedReader reader;
        FileInputStream is;
        Properties answer;
        block6: {
            answer = new Properties();
            if (path.startsWith("file:")) {
                path = ObjectHelper.after(path, "file:");
            }
            is = null;
            reader = null;
            try {
                is = new FileInputStream(path);
                if (this.propertiesComponent.getEncoding() != null) {
                    reader = new BufferedReader(new InputStreamReader((InputStream)is, this.propertiesComponent.getEncoding()));
                    answer.load(reader);
                    break block6;
                }
                answer.load(is);
            }
            catch (FileNotFoundException e) {
                block7: {
                    try {
                        if (ignoreMissingLocation) break block7;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        IOHelper.close(reader, is);
                        throw throwable;
                    }
                }
                IOHelper.close(reader, is);
            }
        }
        IOHelper.close(reader, is);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties loadPropertiesFromClasspath(CamelContext context, boolean ignoreMissingLocation, String path) throws IOException {
        BufferedReader reader;
        InputStream is;
        Properties answer;
        block5: {
            answer = new Properties();
            if (path.startsWith("classpath:")) {
                path = ObjectHelper.after(path, "classpath:");
            }
            is = context.getClassResolver().loadResourceAsStream(path);
            reader = null;
            if (is == null) {
                if (ignoreMissingLocation) return answer;
                throw new FileNotFoundException("Properties file " + path + " not found in classpath");
            }
            try {
                if (this.propertiesComponent.getEncoding() != null) {
                    reader = new BufferedReader(new InputStreamReader(is, this.propertiesComponent.getEncoding()));
                    answer.load(reader);
                    break block5;
                }
                answer.load(is);
            }
            catch (Throwable throwable) {
                IOHelper.close(reader, is);
                throw throwable;
            }
        }
        IOHelper.close(reader, is);
        return answer;
    }

    protected Properties loadPropertiesFromRegistry(CamelContext context, boolean ignoreMissingLocation, String path) throws IOException {
        Properties answer;
        if (path.startsWith("ref:")) {
            path = ObjectHelper.after(path, "ref:");
        }
        try {
            answer = context.getRegistry().lookupByNameAndType(path, Properties.class);
        }
        catch (Exception ex) {
            Map map = context.getRegistry().lookupByNameAndType(path, Map.class);
            answer = new Properties();
            answer.putAll((Map<?, ?>)map);
        }
        if (answer == null && !ignoreMissingLocation) {
            throw new FileNotFoundException("Properties " + path + " not found in registry");
        }
        return answer != null ? answer : new Properties();
    }

    protected Properties prepareLoadedProperties(Properties properties) {
        Properties answer = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String s = (String)value;
                value = DefaultPropertiesResolver.trimTrailingWhitespaces(s);
            }
            answer.put(key, value);
        }
        return answer;
    }

    private static String trimTrailingWhitespaces(String s) {
        int endIndex = s.length();
        int index = s.length() - 1;
        while (index >= 0 && s.charAt(index) == ' ') {
            endIndex = index--;
        }
        String answer = s.substring(0, endIndex);
        return answer;
    }
}

