/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelStreamCachingStrategyDefinition;
import org.apache.camel.impl.DefaultCamelContextNameStrategy;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelConsumerTemplateFactoryBean;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.CamelEndpointFactoryBean;
import org.apache.camel.spring.CamelProducerTemplateFactoryBean;
import org.apache.camel.spring.CamelRedeliveryPolicyFactoryBean;
import org.apache.camel.spring.CamelRestContextFactoryBean;
import org.apache.camel.spring.CamelRouteContextFactoryBean;
import org.apache.camel.spring.CamelThreadPoolFactoryBean;
import org.apache.camel.spring.SpringModelJAXBContextFactory;
import org.apache.camel.spring.handler.BeanDefinitionParser;
import org.apache.camel.spring.handler.ErrorHandlerDefinitionParser;
import org.apache.camel.spring.remoting.CamelProxyFactoryBean;
import org.apache.camel.spring.remoting.CamelServiceExporter;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.spring.KeyStoreParametersFactoryBean;
import org.apache.camel.util.spring.SSLContextParametersFactoryBean;
import org.apache.camel.util.spring.SecureRandomParametersFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CamelNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String SPRING_NS = "http://camel.apache.org/schema/spring";
    private static final Logger LOG = LoggerFactory.getLogger(CamelNamespaceHandler.class);
    protected BeanDefinitionParser endpointParser = new EndpointDefinitionParser();
    protected BeanDefinitionParser beanPostProcessorParser = new BeanDefinitionParser(CamelBeanPostProcessor.class, false);
    protected Set<String> parserElementNames = new HashSet<String>();
    protected Map<String, BeanDefinitionParser> parserMap = new HashMap<String, BeanDefinitionParser>();
    private JAXBContext jaxbContext;
    private Map<String, BeanDefinition> autoRegisterMap = new HashMap<String, BeanDefinition>();

    public static void doBeforeParse(Node node) {
        if (node.getNodeType() == 1) {
            Document doc = node.getOwnerDocument();
            if (node.getNamespaceURI().startsWith("http://camel.apache.org/schema/spring/v")) {
                doc.renameNode(node, SPRING_NS, node.getNodeName());
            }
            NamedNodeMap map = node.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                String changed2;
                String value;
                Node att = map.item(i);
                if (!att.getNodeName().equals("uri") && !att.getNodeName().endsWith("Uri") || (value = att.getNodeValue()).equals(changed2 = value.replaceAll("\\s{2,}", ""))) continue;
                LOG.debug("Removed whitespace noise from attribute {} -> {}", (Object)value, (Object)changed2);
                att.setNodeValue(changed2);
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            CamelNamespaceHandler.doBeforeParse(list.item(i));
        }
    }

    @Override
    public void init() {
        this.registerParser("restContext", new RestContextDefinitionParser());
        this.registerParser("routeContext", new RouteContextDefinitionParser());
        this.registerParser("endpoint", this.endpointParser);
        this.addBeanDefinitionParser("keyStoreParameters", KeyStoreParametersFactoryBean.class, true, true);
        this.addBeanDefinitionParser("secureRandomParameters", SecureRandomParametersFactoryBean.class, true, true);
        this.registerBeanDefinitionParser("sslContextParameters", new SSLContextParametersFactoryBeanBeanDefinitionParser());
        this.addBeanDefinitionParser("proxy", CamelProxyFactoryBean.class, true, false);
        this.addBeanDefinitionParser("template", CamelProducerTemplateFactoryBean.class, true, false);
        this.addBeanDefinitionParser("consumerTemplate", CamelConsumerTemplateFactoryBean.class, true, false);
        this.addBeanDefinitionParser("export", CamelServiceExporter.class, true, false);
        this.addBeanDefinitionParser("threadPool", CamelThreadPoolFactoryBean.class, true, true);
        this.addBeanDefinitionParser("redeliveryPolicyProfile", CamelRedeliveryPolicyFactoryBean.class, true, true);
        this.addBeanDefinitionParser("jmxAgent", CamelJMXAgentDefinition.class, false, false);
        this.addBeanDefinitionParser("streamCaching", CamelStreamCachingStrategyDefinition.class, false, false);
        this.addBeanDefinitionParser("propertyPlaceholder", CamelPropertyPlaceholderDefinition.class, false, false);
        ErrorHandlerDefinitionParser errorHandlerParser = new ErrorHandlerDefinitionParser();
        this.registerParser("errorHandler", errorHandlerParser);
        this.parserMap.put("errorHandler", errorHandlerParser);
        boolean osgi = false;
        Class cl = CamelContextFactoryBean.class;
        try {
            Class.forName("org.osgi.framework.BundleActivator");
            Class<?> c = Class.forName("org.apache.camel.osgi.Activator");
            Method mth = c.getDeclaredMethod("getBundle", new Class[0]);
            Object bundle = mth.invoke(null, new Object[0]);
            if (bundle != null) {
                cl = Class.forName("org.apache.camel.osgi.CamelContextFactoryBean");
                osgi = true;
            }
        }
        catch (Throwable t) {
            LOG.trace("Cannot find class so assuming not running in OSGi container: " + t.getMessage());
        }
        if (osgi) {
            LOG.info("OSGi environment detected.");
        }
        LOG.debug("Using {} as CamelContextBeanDefinitionParser", (Object)cl.getCanonicalName());
        this.registerParser("camelContext", new CamelContextBeanDefinitionParser(cl));
    }

    protected void addBeanDefinitionParser(String elementName, Class<?> type, boolean register, boolean assignId) {
        BeanDefinitionParser parser = new BeanDefinitionParser(type, assignId);
        if (register) {
            this.registerParser(elementName, parser);
        }
        this.parserMap.put(elementName, parser);
    }

    protected void registerParser(String name, org.springframework.beans.factory.xml.BeanDefinitionParser parser) {
        this.parserElementNames.add(name);
        this.registerBeanDefinitionParser(name, parser);
    }

    protected Object parseUsingJaxb(Element element, ParserContext parserContext, Binder<Node> binder) {
        try {
            return binder.unmarshal((Object)element);
        }
        catch (JAXBException e) {
            throw new BeanDefinitionStoreException("Failed to parse JAXB element", e);
        }
    }

    public JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = new SpringModelJAXBContextFactory().newJAXBContext();
        }
        return this.jaxbContext;
    }

    protected void addDependsOn(CamelContextFactoryBean factoryBean, BeanDefinitionBuilder builder) {
        String dependsOn = factoryBean.getDependsOn();
        if (ObjectHelper.isNotEmpty(dependsOn)) {
            String[] depends = dependsOn.split(",|;|\\s");
            if (depends == null) {
                throw new IllegalArgumentException("Cannot separate depends-on, was: " + dependsOn);
            }
            for (String depend : depends) {
                depend = depend.trim();
                LOG.debug("Adding dependsOn {} to CamelContext({})", (Object)depend, (Object)factoryBean.getId());
                builder.addDependsOn(depend);
            }
        }
    }

    private void addDependsOnToRouteBuilder(Element childElement, ParserContext parserContext, String contextId) {
        String routeBuilderName = childElement.getAttribute("ref");
        if (ObjectHelper.isNotEmpty(routeBuilderName)) {
            try {
                BeanDefinition definition = parserContext.getRegistry().getBeanDefinition(routeBuilderName);
                Method getDependsOn = definition.getClass().getMethod("getDependsOn", new Class[0]);
                String[] dependsOn = (String[])getDependsOn.invoke((Object)definition, new Object[0]);
                if (dependsOn == null || dependsOn.length == 0) {
                    dependsOn = new String[]{contextId};
                } else {
                    String[] temp = new String[dependsOn.length + 1];
                    System.arraycopy(dependsOn, 0, temp, 0, dependsOn.length);
                    temp[dependsOn.length] = contextId;
                    dependsOn = temp;
                }
                Method method = definition.getClass().getMethod("setDependsOn", String[].class);
                method.invoke((Object)definition, new Object[]{dependsOn});
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void injectNamespaces(Element element, Binder<Node> binder) {
        NodeList list = element.getChildNodes();
        Namespaces namespaces = null;
        int size2 = list.getLength();
        for (int i = 0; i < size2; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = binder.getJAXBNode((Object)child);
            if (object instanceof NamespaceAware) {
                NamespaceAware namespaceAware = (NamespaceAware)object;
                if (namespaces == null) {
                    namespaces = new Namespaces(element);
                }
                namespaces.configure(namespaceAware);
            }
            this.injectNamespaces(childElement, binder);
        }
    }

    protected void injectBeanPostProcessor(Element element, ParserContext parserContext, String contextId, BeanDefinitionBuilder builder) {
        Element childElement = element.getOwnerDocument().createElement("beanPostProcessor");
        element.appendChild(childElement);
        String beanPostProcessorId = contextId + ":beanPostProcessor";
        childElement.setAttribute("id", beanPostProcessorId);
        BeanDefinition definition = this.beanPostProcessorParser.parse(childElement, parserContext);
        definition.getPropertyValues().addPropertyValue("camelId", contextId);
        builder.addPropertyReference("beanPostProcessor", beanPostProcessorId);
    }

    protected void registerEndpointsWithIdsDefinedInFromOrToTypes(Element element, ParserContext parserContext, String contextId, Binder<Node> binder) {
        NodeList list = element.getChildNodes();
        int size2 = list.getLength();
        for (int i = 0; i < size2; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = binder.getJAXBNode((Object)child);
            if (object instanceof FromDefinition || object instanceof SendDefinition) {
                this.registerEndpoint(childElement, parserContext, contextId);
            }
            this.registerEndpointsWithIdsDefinedInFromOrToTypes(childElement, parserContext, contextId, binder);
        }
    }

    protected void registerTemplates(Element element, ParserContext parserContext, String contextId) {
        BeanDefinition definition;
        BeanDefinitionParser parser;
        Element templateElement;
        String id;
        boolean existing;
        boolean template = false;
        boolean consumerTemplate = false;
        NodeList list = element.getChildNodes();
        int size2 = list.getLength();
        for (int i = 0; i < size2; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            String localName = childElement.getLocalName();
            if ("template".equals(localName)) {
                template = true;
                continue;
            }
            if (!"consumerTemplate".equals(localName)) continue;
            consumerTemplate = true;
        }
        if (!template) {
            existing = this.autoRegisterMap.get("template") != null;
            boolean inUse = false;
            try {
                inUse = parserContext.getRegistry().isBeanNameInUse("template");
            }
            catch (BeanCreationException e) {
                LOG.debug("Error checking isBeanNameInUse(template). This exception will be ignored", e);
            }
            if (!inUse || existing) {
                id = "template";
                templateElement = element.getOwnerDocument().createElement("template");
                templateElement.setAttribute("id", id);
                parser = this.parserMap.get("template");
                definition = parser.parse(templateElement, parserContext);
                this.autoRegisterBeanDefinition(id, definition, parserContext, contextId);
            }
        }
        if (!consumerTemplate) {
            existing = this.autoRegisterMap.get("consumerTemplate") != null;
            boolean inUse = false;
            try {
                inUse = parserContext.getRegistry().isBeanNameInUse("consumerTemplate");
            }
            catch (BeanCreationException e) {
                LOG.debug("Error checking isBeanNameInUse(consumerTemplate). This exception will be ignored", e);
            }
            if (!inUse || existing) {
                id = "consumerTemplate";
                templateElement = element.getOwnerDocument().createElement("consumerTemplate");
                templateElement.setAttribute("id", id);
                parser = this.parserMap.get("consumerTemplate");
                definition = parser.parse(templateElement, parserContext);
                this.autoRegisterBeanDefinition(id, definition, parserContext, contextId);
            }
        }
    }

    private void autoRegisterBeanDefinition(String id, BeanDefinition definition, ParserContext parserContext, String contextId) {
        BeanDefinition existing = this.autoRegisterMap.get(id);
        if (existing == null) {
            this.autoRegisterMap.put(id, definition);
            parserContext.registerComponent(new BeanComponentDefinition(definition, id));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered default: {} with id: {} on camel context: {}", definition.getBeanClassName(), id, contextId);
            }
        } else {
            LOG.debug("Unregistered default: {} with id: {} as we have multiple camel contexts and they must use unique ids. You must define the definition in the XML file manually to avoid id clashes when using multiple camel contexts", (Object)definition.getBeanClassName(), (Object)id);
            parserContext.getRegistry().removeBeanDefinition(id);
        }
    }

    private void registerEndpoint(Element childElement, ParserContext parserContext, String contextId) {
        String id = childElement.getAttribute("id");
        if (ObjectHelper.isNotEmpty(id)) {
            BeanDefinition definition = this.endpointParser.parse(childElement, parserContext);
            definition.getPropertyValues().addPropertyValue("camelContext", new RuntimeBeanReference(contextId));
            try {
                Method method = definition.getClass().getMethod("setDependsOn", String[].class);
                method.invoke((Object)definition, new Object[]{new String[]{contextId}});
            }
            catch (Exception e) {
                // empty catch block
            }
            parserContext.registerBeanComponent(new BeanComponentDefinition(definition, id));
        }
    }

    protected class CamelContextBeanDefinitionParser
    extends BeanDefinitionParser {
        public CamelContextBeanDefinitionParser(Class<?> type) {
            super(type, false);
        }

        @Override
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Binder binder;
            CamelNamespaceHandler.doBeforeParse(element);
            super.doParse(element, parserContext, builder);
            String contextId = element.getAttribute("id");
            boolean implicitId = false;
            if (ObjectHelper.isEmpty(contextId)) {
                DefaultCamelContextNameStrategy strategy = new DefaultCamelContextNameStrategy();
                contextId = strategy.getName();
                element.setAttributeNS(null, "id", contextId);
                implicitId = true;
            }
            try {
                binder = CamelNamespaceHandler.this.getJaxbContext().createBinder();
            }
            catch (JAXBException e) {
                throw new BeanDefinitionStoreException("Failed to create the JAXB binder", e);
            }
            Object value = CamelNamespaceHandler.this.parseUsingJaxb(element, parserContext, (Binder<Node>)binder);
            if (value instanceof CamelContextFactoryBean) {
                CamelContextFactoryBean factoryBean = (CamelContextFactoryBean)value;
                builder.addPropertyValue("id", contextId);
                builder.addPropertyValue("implicitId", implicitId);
                builder.addPropertyValue("restConfiguration", factoryBean.getRestConfiguration());
                builder.addPropertyValue("rests", factoryBean.getRests());
                builder.addPropertyValue("routes", factoryBean.getRoutes());
                builder.addPropertyValue("intercepts", factoryBean.getIntercepts());
                builder.addPropertyValue("interceptFroms", factoryBean.getInterceptFroms());
                builder.addPropertyValue("interceptSendToEndpoints", factoryBean.getInterceptSendToEndpoints());
                builder.addPropertyValue("dataFormats", factoryBean.getDataFormats());
                builder.addPropertyValue("onCompletions", factoryBean.getOnCompletions());
                builder.addPropertyValue("onExceptions", factoryBean.getOnExceptions());
                builder.addPropertyValue("builderRefs", factoryBean.getBuilderRefs());
                builder.addPropertyValue("routeRefs", factoryBean.getRouteRefs());
                builder.addPropertyValue("restRefs", factoryBean.getRestRefs());
                builder.addPropertyValue("properties", factoryBean.getProperties());
                builder.addPropertyValue("packageScan", factoryBean.getPackageScan());
                builder.addPropertyValue("contextScan", factoryBean.getContextScan());
                if (factoryBean.getPackages().length > 0) {
                    builder.addPropertyValue("packages", factoryBean.getPackages());
                }
                builder.addPropertyValue("camelPropertyPlaceholder", factoryBean.getCamelPropertyPlaceholder());
                builder.addPropertyValue("camelJMXAgent", factoryBean.getCamelJMXAgent());
                builder.addPropertyValue("camelStreamCachingStrategy", factoryBean.getCamelStreamCachingStrategy());
                builder.addPropertyValue("threadPoolProfiles", factoryBean.getThreadPoolProfiles());
                CamelNamespaceHandler.this.addDependsOn(factoryBean, builder);
            }
            NodeList list = element.getChildNodes();
            int size2 = list.getLength();
            for (int i = 0; i < size2; ++i) {
                Node child = list.item(i);
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                String localName = child.getLocalName();
                if (localName.equals("endpoint")) {
                    CamelNamespaceHandler.this.registerEndpoint(childElement, parserContext, contextId);
                    continue;
                }
                if (localName.equals("routeBuilder")) {
                    CamelNamespaceHandler.this.addDependsOnToRouteBuilder(childElement, parserContext, contextId);
                    continue;
                }
                BeanDefinitionParser parser = CamelNamespaceHandler.this.parserMap.get(localName);
                if (parser == null) continue;
                BeanDefinition definition = parser.parse(childElement, parserContext);
                String id = childElement.getAttribute("id");
                if (!ObjectHelper.isNotEmpty(id)) continue;
                parserContext.registerComponent(new BeanComponentDefinition(definition, id));
                if (!localName.equals("template") && !localName.equals("consumerTemplate") && !localName.equals("proxy") && !localName.equals("export")) continue;
                definition.getPropertyValues().addPropertyValue("camelContext", new RuntimeBeanReference(contextId));
            }
            CamelNamespaceHandler.this.registerEndpointsWithIdsDefinedInFromOrToTypes(element, parserContext, contextId, (Binder<Node>)binder);
            CamelNamespaceHandler.this.registerTemplates(element, parserContext, contextId);
            CamelNamespaceHandler.this.injectNamespaces(element, (Binder<Node>)binder);
            CamelNamespaceHandler.this.injectBeanPostProcessor(element, parserContext, contextId, builder);
        }
    }

    protected class RestContextDefinitionParser
    extends BeanDefinitionParser {
        public RestContextDefinitionParser() {
            super(CamelRestContextFactoryBean.class, false);
        }

        @Override
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Binder binder;
            CamelNamespaceHandler.doBeforeParse(element);
            super.doParse(element, parserContext, builder);
            try {
                binder = CamelNamespaceHandler.this.getJaxbContext().createBinder();
            }
            catch (JAXBException e) {
                throw new BeanDefinitionStoreException("Failed to create the JAXB binder", e);
            }
            Object value = CamelNamespaceHandler.this.parseUsingJaxb(element, parserContext, (Binder<Node>)binder);
            if (value instanceof CamelRestContextFactoryBean) {
                CamelRestContextFactoryBean factoryBean = (CamelRestContextFactoryBean)value;
                builder.addPropertyValue("rests", factoryBean.getRests());
            }
            CamelNamespaceHandler.this.injectNamespaces(element, (Binder<Node>)binder);
        }
    }

    protected class EndpointDefinitionParser
    extends BeanDefinitionParser {
        public EndpointDefinitionParser() {
            super(CamelEndpointFactoryBean.class, false);
        }

        @Override
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Binder binder;
            CamelNamespaceHandler.doBeforeParse(element);
            super.doParse(element, parserContext, builder);
            try {
                binder = CamelNamespaceHandler.this.getJaxbContext().createBinder();
            }
            catch (JAXBException e) {
                throw new BeanDefinitionStoreException("Failed to create the JAXB binder", e);
            }
            Object value = CamelNamespaceHandler.this.parseUsingJaxb(element, parserContext, (Binder<Node>)binder);
            if (value instanceof CamelEndpointFactoryBean) {
                CamelEndpointFactoryBean factoryBean = (CamelEndpointFactoryBean)value;
                builder.addPropertyValue("properties", factoryBean.getProperties());
            }
        }
    }

    protected class RouteContextDefinitionParser
    extends BeanDefinitionParser {
        public RouteContextDefinitionParser() {
            super(CamelRouteContextFactoryBean.class, false);
        }

        @Override
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Binder binder;
            CamelNamespaceHandler.doBeforeParse(element);
            super.doParse(element, parserContext, builder);
            try {
                binder = CamelNamespaceHandler.this.getJaxbContext().createBinder();
            }
            catch (JAXBException e) {
                throw new BeanDefinitionStoreException("Failed to create the JAXB binder", e);
            }
            Object value = CamelNamespaceHandler.this.parseUsingJaxb(element, parserContext, (Binder<Node>)binder);
            if (value instanceof CamelRouteContextFactoryBean) {
                CamelRouteContextFactoryBean factoryBean = (CamelRouteContextFactoryBean)value;
                builder.addPropertyValue("routes", factoryBean.getRoutes());
            }
            CamelNamespaceHandler.this.injectNamespaces(element, (Binder<Node>)binder);
        }
    }

    protected class SSLContextParametersFactoryBeanBeanDefinitionParser
    extends BeanDefinitionParser {
        public SSLContextParametersFactoryBeanBeanDefinitionParser() {
            super(SSLContextParametersFactoryBean.class, true);
        }

        @Override
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Binder binder;
            CamelNamespaceHandler.doBeforeParse(element);
            super.doParse(element, builder);
            try {
                binder = CamelNamespaceHandler.this.getJaxbContext().createBinder();
            }
            catch (JAXBException e) {
                throw new BeanDefinitionStoreException("Failed to create the JAXB binder", e);
            }
            Object value = CamelNamespaceHandler.this.parseUsingJaxb(element, parserContext, (Binder<Node>)binder);
            if (!(value instanceof SSLContextParametersFactoryBean)) {
                throw new BeanDefinitionStoreException("Parsed type is not of the expected type. Expected " + SSLContextParametersFactoryBean.class.getName() + " but found " + value.getClass().getName());
            }
            SSLContextParametersFactoryBean bean = (SSLContextParametersFactoryBean)value;
            builder.addPropertyValue("cipherSuites", bean.getCipherSuites());
            builder.addPropertyValue("cipherSuitesFilter", bean.getCipherSuitesFilter());
            builder.addPropertyValue("secureSocketProtocols", bean.getSecureSocketProtocols());
            builder.addPropertyValue("secureSocketProtocolsFilter", bean.getSecureSocketProtocolsFilter());
            builder.addPropertyValue("keyManagers", bean.getKeyManagers());
            builder.addPropertyValue("trustManagers", bean.getTrustManagers());
            builder.addPropertyValue("secureRandom", bean.getSecureRandom());
            builder.addPropertyValue("clientParameters", bean.getClientParameters());
            builder.addPropertyValue("serverParameters", bean.getServerParameters());
        }
    }
}

