/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.processor.CamelInternalProcessorAdvice;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.OrderedComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCamelInternalProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SharedCamelInternalProcessor.class);
    private final List<CamelInternalProcessorAdvice> advices = new ArrayList<CamelInternalProcessorAdvice>();

    public SharedCamelInternalProcessor(CamelInternalProcessorAdvice ... advices) {
        if (advices != null) {
            this.advices.addAll(Arrays.asList(advices));
            this.advices.sort(OrderedComparator.get());
        }
    }

    public void process(final Exchange exchange, AsyncProcessor processor, Processor resultProcessor) {
        CountDownLatch latch;
        final AsyncProcessorAwaitManager awaitManager = exchange.getContext().getAsyncProcessorAwaitManager();
        boolean sync = this.process(exchange, new AsyncCallback(latch = new CountDownLatch(1), processor){
            final /* synthetic */ CountDownLatch val$latch;
            final /* synthetic */ AsyncProcessor val$processor;
            {
                this.val$latch = countDownLatch;
                this.val$processor = asyncProcessor;
            }

            @Override
            public void done(boolean doneSync) {
                if (!doneSync) {
                    awaitManager.countDown(exchange, this.val$latch);
                }
            }

            public String toString() {
                return "Done " + this.val$processor;
            }
        }, processor, resultProcessor);
        if (!sync) {
            awaitManager.await(exchange, latch);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback, AsyncProcessor processor, Processor resultProcessor) {
        if (processor == null || !this.continueProcessing(exchange, processor)) {
            callback.done(true);
            return true;
        }
        Object[] states = new Object[this.advices.size()];
        for (int i = 0; i < this.advices.size(); ++i) {
            CamelInternalProcessorAdvice task = this.advices.get(i);
            try {
                Object state = task.before(exchange);
                states[i] = state;
                continue;
            }
            catch (Throwable e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
        }
        callback = new InternalCallback(states, exchange, callback, resultProcessor);
        Object synchronous = exchange.removeProperty("CamelUnitOfWorkProcessSync");
        if (exchange.isTransacted() || synchronous != null) {
            if (LOG.isTraceEnabled()) {
                if (exchange.isTransacted()) {
                    LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                } else {
                    LOG.trace("Synchronous UnitOfWork Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                }
            }
            try {
                processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        UnitOfWork uow = exchange.getUnitOfWork();
        AsyncCallback async = callback;
        if (uow != null) {
            async = uow.beforeProcess(processor, exchange, callback);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchange for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        boolean sync = processor.process(exchange, async);
        if (uow != null) {
            uow.afterProcess(processor, exchange, callback, sync);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exchange processed and is continued routed {} for exchangeId: {} -> {}", sync ? "synchronously" : "asynchronously", exchange.getExchangeId(), exchange);
        }
        return sync;
    }

    protected boolean continueProcessing(Exchange exchange, AsyncProcessor processor) {
        boolean forceShutdown;
        boolean doStop2;
        Object stop2 = exchange.getProperty("CamelRouteStop");
        if (stop2 != null && (doStop2 = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop2).booleanValue())) {
            LOG.debug("Exchange is marked to stop routing: {}", (Object)exchange);
            return false;
        }
        if (processor instanceof Service && (forceShutdown = exchange.getContext().getShutdownStrategy().forceShutdown((Service)((Object)processor)))) {
            String msg = "Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: " + exchange;
            LOG.debug(msg);
            if (exchange.getException() == null) {
                exchange.setException(new RejectedExecutionException(msg));
            }
            return false;
        }
        return true;
    }

    private final class InternalCallback
    implements AsyncCallback {
        private final Object[] states;
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final Processor resultProcessor;

        private InternalCallback(Object[] states, Exchange exchange, AsyncCallback callback, Processor resultProcessor) {
            this.states = states;
            this.exchange = exchange;
            this.callback = callback;
            this.resultProcessor = resultProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(boolean doneSync) {
            if (this.resultProcessor != null) {
                try {
                    this.resultProcessor.process(this.exchange);
                }
                catch (Throwable e) {
                    this.exchange.setException(e);
                }
            }
            try {
                for (int i = SharedCamelInternalProcessor.this.advices.size() - 1; i >= 0; --i) {
                    CamelInternalProcessorAdvice task = (CamelInternalProcessorAdvice)SharedCamelInternalProcessor.this.advices.get(i);
                    Object state = this.states[i];
                    try {
                        task.after(this.exchange, state);
                        continue;
                    }
                    catch (Throwable e) {
                        this.exchange.setException(e);
                    }
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }
    }
}

