/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Ordered;
import org.apache.camel.Processor;
import org.apache.camel.api.management.PerformanceCounter;
import org.apache.camel.management.DelegatePerformanceCounter;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.processor.CamelInternalProcessorAdvice;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationProcessor
extends DelegateAsyncProcessor
implements CamelInternalProcessorAdvice<StopWatch>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(InstrumentationProcessor.class);
    private PerformanceCounter counter;
    private String type;

    public InstrumentationProcessor(String type, Processor processor) {
        super(processor);
        this.type = type;
    }

    public void setCounter(Object counter) {
        ManagedPerformanceCounter mpc = null;
        if (counter instanceof ManagedPerformanceCounter) {
            mpc = (ManagedPerformanceCounter)counter;
        }
        if (this.counter instanceof DelegatePerformanceCounter) {
            ((DelegatePerformanceCounter)this.counter).setCounter(mpc);
        } else if (mpc != null) {
            this.counter = mpc;
        } else if (counter instanceof PerformanceCounter) {
            this.counter = (PerformanceCounter)counter;
        }
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        StopWatch watch;
        StopWatch stopWatch = watch = this.counter != null && this.counter.isStatisticsEnabled() ? new StopWatch() : null;
        if (watch != null) {
            this.beginTime(exchange);
        }
        return this.processor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                try {
                    if (watch != null) {
                        InstrumentationProcessor.this.recordTime(exchange, watch.taken());
                    }
                }
                finally {
                    callback.done(doneSync);
                }
            }

            public String toString() {
                return InstrumentationProcessor.this.toString();
            }
        });
    }

    protected void beginTime(Exchange exchange) {
        this.counter.processExchange(exchange);
    }

    protected void recordTime(Exchange exchange, long duration) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}Recording duration: {} millis for exchange: {}", this.type != null ? this.type + ": " : "", duration, exchange);
        }
        if (!exchange.isFailed() && exchange.getException() == null) {
            this.counter.completedExchange(exchange, duration);
        } else {
            this.counter.failedExchange(exchange);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public StopWatch before(Exchange exchange) throws Exception {
        StopWatch answer;
        StopWatch stopWatch = answer = this.counter != null && this.counter.isStatisticsEnabled() ? new StopWatch() : null;
        if (answer != null) {
            this.beginTime(exchange);
        }
        return answer;
    }

    @Override
    public void after(Exchange exchange, StopWatch watch) throws Exception {
        if (watch != null) {
            this.recordTime(exchange, watch.taken());
        }
    }

    @Override
    public String toString() {
        return "InstrumentProcessorAdvice";
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFD;
    }
}

