/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.1.0", label="dataformat,transformation,xml", title="Castor")
@XmlRootElement(name="castor")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CastorDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String mappingFile;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean validation;
    @XmlAttribute
    @Metadata(defaultValue="UTF-8")
    private String encoding;
    @XmlAttribute
    private String[] packages;
    @XmlAttribute
    private String[] classes;

    public CastorDataFormat() {
        super("castor");
    }

    public Boolean getValidation() {
        return this.validation;
    }

    public void setValidation(Boolean validation) {
        this.validation = validation;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public String[] getClasses() {
        return this.classes;
    }

    public void setClasses(String[] classes) {
        this.classes = classes;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.mappingFile != null) {
            this.setProperty(camelContext, dataFormat, "mappingFile", this.mappingFile);
        }
        boolean isValidation = this.getValidation() == null || this.getValidation() != false;
        this.setProperty(camelContext, dataFormat, "validation", isValidation);
        if (this.encoding != null) {
            this.setProperty(camelContext, dataFormat, "encoding", this.encoding);
        }
        if (this.packages != null) {
            this.setProperty(camelContext, dataFormat, "packages", this.packages);
        }
        if (this.classes != null) {
            this.setProperty(camelContext, dataFormat, "classes", this.classes);
        }
    }
}

