/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.ComponentVerifierHelper;
import org.apache.camel.util.ObjectHelper;

public interface ComponentVerifier {
    public Result verify(Scope var1, Map<String, Object> var2);

    public static interface VerificationError
    extends Serializable {
        public Code getCode();

        public String getDescription();

        public Set<String> getParameterKeys();

        public Map<Attribute, Object> getDetails();

        default public Object getDetail(Attribute attribute) {
            Map<Attribute, Object> details = this.getDetails();
            if (details != null) {
                return details.get(attribute);
            }
            return null;
        }

        default public Object getDetail(String attribute) {
            return this.getDetail(VerificationError.asAttribute(attribute));
        }

        public static Code asCode(String code) {
            return new ComponentVerifierHelper.ErrorCode(code);
        }

        public static Attribute asAttribute(String attribute) {
            return new ComponentVerifierHelper.ErrorAttribute(attribute);
        }

        public static interface GroupAttribute
        extends Attribute {
            public static final GroupAttribute GROUP_NAME = new ComponentVerifierHelper.GroupErrorAttribute("GROUP_NAME");
            public static final GroupAttribute GROUP_OPTIONS = new ComponentVerifierHelper.GroupErrorAttribute("GROUP_OPTIONS");
        }

        public static interface HttpAttribute
        extends Attribute {
            public static final HttpAttribute HTTP_CODE = new ComponentVerifierHelper.HttpErrorAttribute("HTTP_CODE");
            public static final HttpAttribute HTTP_TEXT = new ComponentVerifierHelper.HttpErrorAttribute("HTTP_TEXT");
            public static final HttpAttribute HTTP_REDIRECT = new ComponentVerifierHelper.HttpErrorAttribute("HTTP_REDIRECT");
        }

        public static interface ExceptionAttribute
        extends Attribute {
            public static final ExceptionAttribute EXCEPTION_INSTANCE = new ComponentVerifierHelper.ExceptionErrorAttribute("EXCEPTION_INSTANCE");
            public static final ExceptionAttribute EXCEPTION_CLASS = new ComponentVerifierHelper.ExceptionErrorAttribute("EXCEPTION_CLASS");
        }

        public static interface Attribute
        extends Serializable {
            public String name();

            default public String getName() {
                return this.name();
            }
        }

        public static interface StandardCode
        extends Code {
            public static final StandardCode AUTHENTICATION = new ComponentVerifierHelper.StandardErrorCode("AUTHENTICATION");
            public static final StandardCode EXCEPTION = new ComponentVerifierHelper.StandardErrorCode("EXCEPTION");
            public static final StandardCode INTERNAL = new ComponentVerifierHelper.StandardErrorCode("INTERNAL");
            public static final StandardCode MISSING_PARAMETER = new ComponentVerifierHelper.StandardErrorCode("MISSING_PARAMETER");
            public static final StandardCode UNKNOWN_PARAMETER = new ComponentVerifierHelper.StandardErrorCode("UNKNOWN_PARAMETER");
            public static final StandardCode ILLEGAL_PARAMETER = new ComponentVerifierHelper.StandardErrorCode("ILLEGAL_PARAMETER");
            public static final StandardCode ILLEGAL_PARAMETER_GROUP_COMBINATION = new ComponentVerifierHelper.StandardErrorCode("ILLEGAL_PARAMETER_GROUP_COMBINATION");
            public static final StandardCode ILLEGAL_PARAMETER_VALUE = new ComponentVerifierHelper.StandardErrorCode("ILLEGAL_PARAMETER_VALUE");
            public static final StandardCode INCOMPLETE_PARAMETER_GROUP = new ComponentVerifierHelper.StandardErrorCode("INCOMPLETE_PARAMETER_GROUP");
            public static final StandardCode UNSUPPORTED = new ComponentVerifierHelper.StandardErrorCode("UNSUPPORTED");
            public static final StandardCode UNSUPPORTED_SCOPE = new ComponentVerifierHelper.StandardErrorCode("UNSUPPORTED_SCOPE");
            public static final StandardCode UNSUPPORTED_COMPONENT = new ComponentVerifierHelper.StandardErrorCode("UNSUPPORTED_COMPONENT");
            public static final StandardCode GENERIC = new ComponentVerifierHelper.StandardErrorCode("GENERIC");
        }

        public static interface Code
        extends Serializable {
            public String name();

            default public String getName() {
                return this.name();
            }
        }
    }

    public static enum Scope {
        PARAMETERS,
        CONNECTIVITY;

        private static final Scope[] VALUES;

        public static Scope fromString(String scope) {
            for (Scope value : VALUES) {
                if (!ObjectHelper.equal(scope, value.name(), true)) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown scope <" + scope + ">");
        }

        static {
            VALUES = Scope.values();
        }
    }

    public static interface Result
    extends Serializable {
        public Scope getScope();

        public Status getStatus();

        public List<VerificationError> getErrors();

        public static enum Status {
            OK,
            ERROR,
            UNSUPPORTED;

        }
    }
}

