/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProcessor
extends ServiceSupport
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(BeanProcessor.class);
    private final BeanHolder beanHolder;
    private Processor processor;
    private boolean multiParameterArray;
    private String method;
    private boolean shorthandMethod;

    public BeanProcessor(Object pojo, BeanInfo beanInfo) {
        this(new ConstantBeanHolder(pojo, beanInfo));
    }

    public BeanProcessor(Object pojo, CamelContext camelContext, ParameterMappingStrategy parameterMappingStrategy) {
        this(pojo, new BeanInfo(camelContext, pojo.getClass(), parameterMappingStrategy));
    }

    public BeanProcessor(Object pojo, CamelContext camelContext) {
        this(pojo, camelContext, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanProcessor(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public String toString() {
        return "BeanProcessor[" + this.beanHolder + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        MethodInvocation invocation;
        BeanInfo beanInfo;
        Object bean;
        String explicitMethodName = exchange.getIn().getHeader("CamelBeanMethodName", this.method, String.class);
        try {
            bean = this.beanHolder.getBean();
            beanInfo = this.beanHolder.getBeanInfo(bean);
            if (beanInfo == null) {
                beanInfo = this.beanHolder.getBeanInfo();
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        if (this.allowProcessor(explicitMethodName, beanInfo)) {
            Processor processor = this.getProcessor();
            if (processor == null) {
                processor = exchange.getContext().getTypeConverter().tryConvertTo(Processor.class, exchange, bean);
            }
            if (processor != null) {
                LOG.trace("Using a custom adapter as bean invocation: {}", (Object)processor);
                try {
                    processor.process(exchange);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                callback.done(true);
                return true;
            }
        }
        Message in = exchange.getIn();
        BeanInvocation beanInvoke = null;
        if (in.getBody() != null && in.getBody() instanceof BeanInvocation) {
            beanInvoke = (BeanInvocation)in.getBody();
        }
        if (beanInvoke != null) {
            LOG.trace("Exchange IN body is a BeanInvocation instance: {}", (Object)beanInvoke);
            Class<?> clazz = beanInvoke.getMethod().getDeclaringClass();
            boolean sameBean = clazz.isInstance(bean);
            if (LOG.isDebugEnabled()) {
                LOG.debug("BeanHolder bean: {} and beanInvocation bean: {} is same instance: {}", bean.getClass(), clazz, sameBean);
            }
            if (sameBean) {
                try {
                    beanInvoke.invoke(bean, exchange);
                    if (exchange.hasOut()) {
                        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                    }
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                callback.done(true);
                return true;
            }
        }
        if (in.getHeader("CamelBeanMultiParameterArray") == null) {
            in.setHeader("CamelBeanMultiParameterArray", this.isMultiParameterArray());
        }
        if (explicitMethodName != null) {
            in.setHeader("CamelBeanMethodName", explicitMethodName);
        }
        try {
            invocation = beanInfo.createInvocation(bean, exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            in.removeHeader("CamelBeanMultiParameterArray");
            in.removeHeader("CamelBeanMethodName");
        }
        if (invocation == null) {
            exchange.setException(new IllegalStateException("No method invocation could be created, no matching method could be found on: " + bean));
            callback.done(true);
            return true;
        }
        return invocation.proceed(callback);
    }

    protected Processor getProcessor() {
        return this.processor;
    }

    protected BeanHolder getBeanHolder() {
        return this.beanHolder;
    }

    public Object getBean() {
        return this.beanHolder.getBean();
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isMultiParameterArray() {
        return this.multiParameterArray;
    }

    public void setMultiParameterArray(boolean mpArray) {
        this.multiParameterArray = mpArray;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isShorthandMethod() {
        return this.shorthandMethod;
    }

    public void setShorthandMethod(boolean shorthandMethod) {
        this.shorthandMethod = shorthandMethod;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.beanHolder.supportProcessor() && this.allowProcessor(this.method, this.beanHolder.getBeanInfo())) {
            this.processor = this.beanHolder.getProcessor();
            ServiceHelper.startService(this.processor);
        } else if (this.beanHolder instanceof ConstantBeanHolder) {
            try {
                ServiceHelper.startService(this.beanHolder.getBean());
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.processor != null) {
            ServiceHelper.stopService(this.processor);
        } else if (this.beanHolder instanceof ConstantBeanHolder) {
            try {
                ServiceHelper.stopService(this.beanHolder.getBean());
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    private boolean allowProcessor(String explicitMethodName, BeanInfo info) {
        if (explicitMethodName != null) {
            return false;
        }
        for (MethodInfo method : info.getMethods()) {
            if (!method.hasHandlerAnnotation()) continue;
            return false;
        }
        return true;
    }
}

