/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.mbean.ManagedClusterServiceMBean;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.impl.cluster.ClusterServiceHelper;
import org.apache.camel.spi.ManagementStrategy;

public class ManagedClusterService
implements ManagedClusterServiceMBean {
    private final CamelContext context;
    private final CamelClusterService service;

    public ManagedClusterService(CamelContext context, CamelClusterService service) {
        this.context = context;
        this.service = service;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    public CamelClusterService getService() {
        return this.service;
    }

    @Override
    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.service.start();
    }

    @Override
    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.service.stop();
    }

    @Override
    public String getState() {
        if (this.service instanceof StatefulService) {
            ServiceStatus status2 = ((StatefulService)((Object)this.service)).getStatus();
            return status2.name();
        }
        return ServiceStatus.Started.name();
    }

    @Override
    public String getCamelId() {
        return this.context.getName();
    }

    @Override
    public Collection<String> getNamespaces() {
        return ClusterServiceHelper.lookupService(this.context).map(CamelClusterService::getNamespaces).orElseGet(Collections::emptyList);
    }

    @Override
    public void startView(String namespace) throws Exception {
        Optional<CamelClusterService> service = ClusterServiceHelper.lookupService(this.context);
        if (service.isPresent()) {
            service.get().startView(namespace);
        }
    }

    @Override
    public void stopView(String namespace) throws Exception {
        Optional<CamelClusterService> service = ClusterServiceHelper.lookupService(this.context);
        if (service.isPresent()) {
            service.get().stopView(namespace);
        }
    }

    @Override
    public boolean isLeader(String namespace) {
        return ClusterServiceHelper.lookupService(this.context).map(s -> s.isLeader(namespace)).orElse(false);
    }
}

