/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.view;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.view.BrokerDestinationView;
import org.apache.activemq.broker.view.MessageBrokerView;
import org.apache.activemq.broker.view.MessageBrokerViewRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BrokerDestinationViewTest {
    protected BrokerService brokerService;
    protected ActiveMQConnectionFactory factory;
    protected Connection producerConnection;
    protected Session producerSession;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Queue queue;
    protected int messageCount = 10000;
    protected int timeOutInSeconds = 10;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.start();
        this.factory = new ActiveMQConnectionFactory(BrokerRegistry.getInstance().findFirst().getVmConnectorURI());
        this.producerConnection = this.factory.createConnection();
        this.producerConnection.start();
        this.producerSession = this.producerConnection.createSession(false, 1);
        this.queue = this.producerSession.createQueue(this.getClass().getName());
        this.producer = this.producerSession.createProducer((Destination)this.queue);
    }

    @After
    public void tearDown() throws Exception {
        if (this.producerConnection != null) {
            this.producerConnection.close();
        }
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    @Test
    public void testBrokerDestinationView() throws Exception {
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = this.producerSession.createTextMessage("test " + i);
            this.producer.send((Message)message);
        }
        MessageBrokerView messageBrokerView = MessageBrokerViewRegistry.getInstance().lookup("");
        BrokerDestinationView destinationView = messageBrokerView.getQueueDestinationView(this.getClass().getName());
        Assert.assertEquals((long)destinationView.getQueueSize(), (long)this.messageCount);
    }
}

