/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import org.apache.activemq.util.MemoryIntPropertyEditor;
import org.apache.activemq.util.MemoryPropertyEditor;
import org.junit.Assert;
import org.junit.Test;

public class PropertyEditorTest {
    @Test
    public void testLongBytes() throws Exception {
        MemoryPropertyEditor propertyEditor = new MemoryPropertyEditor();
        String expectedResult = String.valueOf(1000L);
        propertyEditor.setAsText("1000b");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000B");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
    }

    @Test
    public void testIntegerBytes() throws Exception {
        MemoryIntPropertyEditor propertyEditor = new MemoryIntPropertyEditor();
        String expectedResult = String.valueOf(1000);
        propertyEditor.setAsText("1000b");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000B");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
    }

    @Test
    public void testLongKiloBytes() throws Exception {
        MemoryPropertyEditor propertyEditor = new MemoryPropertyEditor();
        String expectedResult = String.valueOf(1024000L);
        propertyEditor.setAsText("1000kb");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000k");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000KB");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
    }

    @Test
    public void testIntegerKiloBytes() throws Exception {
        MemoryIntPropertyEditor propertyEditor = new MemoryIntPropertyEditor();
        String expectedResult = String.valueOf(1024000);
        propertyEditor.setAsText("1000kb");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000k");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000KB");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
    }

    @Test
    public void testLongMegaBytes() throws Exception {
        MemoryPropertyEditor propertyEditor = new MemoryPropertyEditor();
        String expectedResult = String.valueOf(1048576000L);
        propertyEditor.setAsText("1000mb");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000m");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000MB");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
    }

    @Test
    public void testIntegerMegaBytes() throws Exception {
        MemoryIntPropertyEditor propertyEditor = new MemoryIntPropertyEditor();
        String expectedResult = String.valueOf(1048576000);
        propertyEditor.setAsText("1000mb");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000m");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000MB");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
    }

    @Test
    public void testLongGigaBytes() throws Exception {
        MemoryPropertyEditor propertyEditor = new MemoryPropertyEditor();
        String expectedResult = String.valueOf(0xFA00000000L);
        propertyEditor.setAsText("1000gb");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000g");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000GB");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
    }

    @Test
    public void testIntegerGigaBytes() throws Exception {
        MemoryIntPropertyEditor propertyEditor = new MemoryIntPropertyEditor();
        String expectedResult = String.valueOf(0);
        propertyEditor.setAsText("1000gb");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000g");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
        propertyEditor.setAsText("1000GB");
        Assert.assertEquals((Object)expectedResult, (Object)propertyEditor.getAsText());
    }
}

