/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.util.URISupport;
import org.junit.Assert;
import org.junit.Test;

public class URISupportTest {
    @Test
    public void testEmptyCompositePath() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("broker:()/localhost?persistent=false"));
        Assert.assertEquals((long)0L, (long)data.getComponents().length);
    }

    @Test
    public void testCompositePath() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:(path)/path"));
        Assert.assertEquals((Object)"path", (Object)data.getPath());
        data = URISupport.parseComposite((URI)new URI("test:path"));
        Assert.assertNull((Object)data.getPath());
    }

    @Test
    public void testSimpleComposite() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:part1"));
        Assert.assertEquals((long)1L, (long)data.getComponents().length);
    }

    @Test
    public void testComposite() throws Exception {
        URI uri = new URI("test:(part1://host,part2://(sub1://part,sube2:part))");
        URISupport.CompositeData data = URISupport.parseComposite((URI)uri);
        Assert.assertEquals((long)2L, (long)data.getComponents().length);
    }

    @Test
    public void testEmptyCompositeWithParenthesisInParam() throws Exception {
        URI uri = new URI("failover://()?updateURIsURL=file:/C:/Dir(1)/a.csv");
        URISupport.CompositeData data = URISupport.parseComposite((URI)uri);
        Assert.assertEquals((long)0L, (long)data.getComponents().length);
        Assert.assertEquals((long)1L, (long)data.getParameters().size());
        Assert.assertTrue((boolean)data.getParameters().containsKey("updateURIsURL"));
        Assert.assertEquals((Object)"file:/C:/Dir(1)/a.csv", data.getParameters().get("updateURIsURL"));
    }

    @Test
    public void testCompositeWithParenthesisInParam() throws Exception {
        URI uri = new URI("failover://(test)?updateURIsURL=file:/C:/Dir(1)/a.csv");
        URISupport.CompositeData data = URISupport.parseComposite((URI)uri);
        Assert.assertEquals((long)1L, (long)data.getComponents().length);
        Assert.assertEquals((long)1L, (long)data.getParameters().size());
        Assert.assertTrue((boolean)data.getParameters().containsKey("updateURIsURL"));
        Assert.assertEquals((Object)"file:/C:/Dir(1)/a.csv", data.getParameters().get("updateURIsURL"));
    }

    @Test
    public void testCompositeWithComponentParam() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:(part1://host?part1=true)?outside=true"));
        Assert.assertEquals((long)1L, (long)data.getComponents().length);
        Assert.assertEquals((long)1L, (long)data.getParameters().size());
        Map part1Params = URISupport.parseParameters((URI)data.getComponents()[0]);
        Assert.assertEquals((long)1L, (long)part1Params.size());
        Assert.assertTrue((boolean)part1Params.containsKey("part1"));
    }

    @Test
    public void testParsingURI() throws Exception {
        URI source = new URI("tcp://localhost:61626/foo/bar?cheese=Edam&x=123");
        Map map = URISupport.parseParameters((URI)source);
        Assert.assertEquals((String)("Size: " + map), (long)2L, (long)map.size());
        this.assertMapKey(map, "cheese", "Edam");
        this.assertMapKey(map, "x", "123");
        URI result = URISupport.removeQuery((URI)source);
        Assert.assertEquals((String)"result", (Object)new URI("tcp://localhost:61626/foo/bar"), (Object)result);
    }

    protected void assertMapKey(Map<String, String> map, String key, Object expected) {
        Assert.assertEquals((String)("Map key: " + key), (Object)map.get(key), (Object)expected);
    }

    @Test
    public void testParsingCompositeURI() throws URISyntaxException {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("broker://(tcp://localhost:61616)?name=foo"));
        Assert.assertEquals((String)"one component", (long)1L, (long)data.getComponents().length);
        Assert.assertEquals((String)("Size: " + data.getParameters()), (long)1L, (long)data.getParameters().size());
    }

    @Test
    public void testCheckParenthesis() throws Exception {
        String str = "fred:(((ddd))";
        Assert.assertFalse((boolean)URISupport.checkParenthesis((String)str));
        str = str + ")";
        Assert.assertTrue((boolean)URISupport.checkParenthesis((String)str));
    }

    @Test
    public void testCreateWithQuery() throws Exception {
        URI source = new URI("vm://localhost");
        URI dest = URISupport.createURIWithQuery((URI)source, (String)"network=true&one=two");
        Assert.assertEquals((String)"correct param count", (long)2L, (long)URISupport.parseParameters((URI)dest).size());
        Assert.assertEquals((String)"same uri, host", (Object)source.getHost(), (Object)dest.getHost());
        Assert.assertEquals((String)"same uri, scheme", (Object)source.getScheme(), (Object)dest.getScheme());
        Assert.assertFalse((String)"same uri, ssp", (boolean)dest.getQuery().equals(source.getQuery()));
    }

    @Test
    public void testParsingParams() throws Exception {
        URI uri = new URI("static:(http://localhost:61617?proxyHost=jo&proxyPort=90)?proxyHost=localhost&proxyPort=80");
        Map parameters = URISupport.parseParameters((URI)uri);
        this.verifyParams(parameters);
        uri = new URI("static://http://localhost:61617?proxyHost=localhost&proxyPort=80");
        parameters = URISupport.parseParameters((URI)uri);
        this.verifyParams(parameters);
        uri = new URI("http://0.0.0.0:61616");
        parameters = URISupport.parseParameters((URI)uri);
    }

    @Test
    public void testCompositeCreateURIWithQuery() throws Exception {
        URI originalURI;
        String queryString = "query=value";
        URI querylessURI = originalURI = new URI("outerscheme:(innerscheme:innerssp)");
        Assert.assertEquals((Object)querylessURI, (Object)URISupport.createURIWithQuery((URI)originalURI, null));
        Assert.assertEquals((Object)querylessURI, (Object)URISupport.createURIWithQuery((URI)originalURI, (String)""));
        Assert.assertEquals((Object)new URI(querylessURI + "?" + queryString), (Object)URISupport.createURIWithQuery((URI)originalURI, (String)queryString));
        originalURI = new URI("outerscheme:(innerscheme:innerssp)?outerquery=0");
        Assert.assertEquals((Object)querylessURI, (Object)URISupport.createURIWithQuery((URI)originalURI, null));
        Assert.assertEquals((Object)querylessURI, (Object)URISupport.createURIWithQuery((URI)originalURI, (String)""));
        Assert.assertEquals((Object)new URI(querylessURI + "?" + queryString), (Object)URISupport.createURIWithQuery((URI)originalURI, (String)queryString));
        querylessURI = originalURI = new URI("outerscheme:(innerscheme:innerssp?innerquery=0)");
        Assert.assertEquals((Object)querylessURI, (Object)URISupport.createURIWithQuery((URI)originalURI, null));
        Assert.assertEquals((Object)querylessURI, (Object)URISupport.createURIWithQuery((URI)originalURI, (String)""));
        Assert.assertEquals((Object)new URI(querylessURI + "?" + queryString), (Object)URISupport.createURIWithQuery((URI)originalURI, (String)queryString));
        originalURI = new URI("outerscheme:(innerscheme:innerssp?innerquery=0)?outerquery=0");
        Assert.assertEquals((Object)querylessURI, (Object)URISupport.createURIWithQuery((URI)originalURI, null));
        Assert.assertEquals((Object)querylessURI, (Object)URISupport.createURIWithQuery((URI)originalURI, (String)""));
        Assert.assertEquals((Object)new URI(querylessURI + "?" + queryString), (Object)URISupport.createURIWithQuery((URI)originalURI, (String)queryString));
    }

    @Test
    public void testApplyParameters() throws Exception {
        URI uri = new URI("http://0.0.0.0:61616");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("t.proxyHost", "localhost");
        parameters.put("t.proxyPort", "80");
        uri = URISupport.applyParameters((URI)uri, parameters);
        Map appliedParameters = URISupport.parseParameters((URI)uri);
        Assert.assertEquals((String)"all params applied  with no prefix", (long)2L, (long)appliedParameters.size());
        uri = URISupport.createURIWithQuery((URI)uri, null);
        uri = URISupport.applyParameters((URI)uri, parameters, (String)"joe");
        appliedParameters = URISupport.parseParameters((URI)uri);
        Assert.assertTrue((String)"no params applied as none match joe", (boolean)appliedParameters.isEmpty());
        uri = URISupport.applyParameters((URI)uri, parameters, (String)"t.");
        this.verifyParams(URISupport.parseParameters((URI)uri));
    }

    private void verifyParams(Map<String, String> parameters) {
        Assert.assertEquals((Object)parameters.get("proxyHost"), (Object)"localhost");
        Assert.assertEquals((Object)parameters.get("proxyPort"), (Object)"80");
    }

    @Test
    public void testIsCompositeURIWithQueryNoSlashes() throws URISyntaxException {
        URI[] compositeURIs;
        for (URI uri : compositeURIs = new URI[]{new URI("test:(part1://host?part1=true)?outside=true"), new URI("broker:(tcp://localhost:61616)?name=foo")}) {
            Assert.assertTrue((String)(uri + " must be detected as composite URI"), (boolean)URISupport.isCompositeURI((URI)uri));
        }
    }

    @Test
    public void testIsCompositeURIWithQueryAndSlashes() throws URISyntaxException {
        URI[] compositeURIs;
        for (URI uri : compositeURIs = new URI[]{new URI("test://(part1://host?part1=true)?outside=true"), new URI("broker://(tcp://localhost:61616)?name=foo")}) {
            Assert.assertTrue((String)(uri + " must be detected as composite URI"), (boolean)URISupport.isCompositeURI((URI)uri));
        }
    }

    @Test
    public void testIsCompositeURINoQueryNoSlashes() throws URISyntaxException {
        URI[] compositeURIs;
        for (URI uri : compositeURIs = new URI[]{new URI("test:(part1://host,part2://(sub1://part,sube2:part))"), new URI("test:(path)/path")}) {
            Assert.assertTrue((String)(uri + " must be detected as composite URI"), (boolean)URISupport.isCompositeURI((URI)uri));
        }
    }

    @Test
    public void testIsCompositeURINoQueryNoSlashesNoParentheses() throws URISyntaxException {
        Assert.assertFalse((String)"test:part1 must be detected as non-composite URI", (boolean)URISupport.isCompositeURI((URI)new URI("test:part1")));
    }

    @Test
    public void testIsCompositeURINoQueryWithSlashes() throws URISyntaxException {
        URI[] compositeURIs;
        for (URI uri : compositeURIs = new URI[]{new URI("failover://(tcp://bla:61616,tcp://bla:61617)"), new URI("failover://(tcp://localhost:61616,ssl://anotherhost:61617)")}) {
            Assert.assertTrue((String)(uri + " must be detected as composite URI"), (boolean)URISupport.isCompositeURI((URI)uri));
        }
    }
}

