/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.usage.MemoryUsage;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryUsageConcurrencyTest {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryUsageConcurrencyTest.class);

    @Test
    public void testCycle() throws Exception {
        Random r = new Random(739860L);
        for (int i = 0; i < 30000; ++i) {
            this.checkPercentage(i, i, r.nextInt(100) + 10, i % 2 == 0, i % 5 == 0);
        }
    }

    private void checkPercentage(int attempt, int seed, int operations, boolean useArrayBlocking, boolean useWaitForSpaceThread) throws InterruptedException {
        AbstractQueue removed;
        AbstractQueue toRemove;
        AbstractQueue toAdd;
        if (useArrayBlocking) {
            toAdd = new ArrayBlockingQueue(operations);
            toRemove = new ArrayBlockingQueue(operations);
            removed = new ArrayBlockingQueue(operations);
        } else {
            toAdd = new LinkedBlockingQueue();
            toRemove = new LinkedBlockingQueue();
            removed = new LinkedBlockingQueue();
        }
        final AtomicBoolean running = new AtomicBoolean(true);
        final CountDownLatch startLatch = new CountDownLatch(1);
        final MemoryUsage memUsage = new MemoryUsage();
        memUsage.setLimit(1000L);
        memUsage.start();
        Thread addThread = new Thread(new Runnable((BlockingQueue)((Object)toAdd), running, (BlockingQueue)((Object)toRemove), memUsage){
            final /* synthetic */ BlockingQueue val$toAdd;
            final /* synthetic */ AtomicBoolean val$running;
            final /* synthetic */ BlockingQueue val$toRemove;
            final /* synthetic */ MemoryUsage val$memUsage;
            {
                this.val$toAdd = blockingQueue;
                this.val$running = atomicBoolean;
                this.val$toRemove = blockingQueue2;
                this.val$memUsage = memoryUsage;
            }

            @Override
            public void run() {
                try {
                    startLatch.await();
                    while (true) {
                        Integer add;
                        if ((add = (Integer)this.val$toAdd.poll(1L, TimeUnit.MILLISECONDS)) == null) {
                            if (this.val$running.get()) continue;
                            break;
                        }
                        this.val$toRemove.add(add);
                        this.val$memUsage.increaseUsage((long)add.intValue());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Thread removeThread = new Thread(new Runnable((BlockingQueue)((Object)toRemove), running, memUsage, (BlockingQueue)((Object)removed)){
            final /* synthetic */ BlockingQueue val$toRemove;
            final /* synthetic */ AtomicBoolean val$running;
            final /* synthetic */ MemoryUsage val$memUsage;
            final /* synthetic */ BlockingQueue val$removed;
            {
                this.val$toRemove = blockingQueue;
                this.val$running = atomicBoolean;
                this.val$memUsage = memoryUsage;
                this.val$removed = blockingQueue2;
            }

            @Override
            public void run() {
                try {
                    startLatch.await();
                    while (true) {
                        Integer remove;
                        if ((remove = (Integer)this.val$toRemove.poll(1L, TimeUnit.MILLISECONDS)) == null) {
                            if (this.val$running.get()) continue;
                            break;
                        }
                        this.val$memUsage.decreaseUsage((long)remove.intValue());
                        this.val$removed.add(remove);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Thread waitForSpaceThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    startLatch.await();
                    while (running.get()) {
                        memUsage.waitForSpace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        removeThread.start();
        addThread.start();
        if (useWaitForSpaceThread) {
            waitForSpaceThread.start();
        }
        Random r = new Random(seed);
        startLatch.countDown();
        for (int i = 0; i < operations; ++i) {
            toAdd.add(r.nextInt(100) + 1);
        }
        ArrayList<Integer> ops = new ArrayList<Integer>(operations);
        for (int i = 0; i < operations; ++i) {
            Integer op = (Integer)removed.poll(1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull((Object)op);
            ops.add(op);
        }
        running.set(false);
        if (useWaitForSpaceThread) {
            try {
                waitForSpaceThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug("Attempt: {} : {} waitForSpace never returned", (Object)attempt, (Object)memUsage);
                waitForSpaceThread.interrupt();
                waitForSpaceThread.join();
            }
        }
        removeThread.join();
        addThread.join();
        if (memUsage.getPercentUsage() != 0 || memUsage.getUsage() != (long)memUsage.getPercentUsage()) {
            LOG.debug("Attempt: {} : {}", (Object)attempt, (Object)memUsage);
            LOG.debug("Operations: {}", ops);
            Assert.assertEquals((long)0L, (long)memUsage.getPercentUsage());
        }
    }
}

