/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import org.apache.activemq.ActiveMQMessageAuditNoSync;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LongSequenceGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActiveMQMessageAuditNotSyncTest {
    private final IdGenerator connectionIdGenerator = new IdGenerator();
    private final LongSequenceGenerator sessionIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator producerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator sequenceIdGenerator = new LongSequenceGenerator();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAuditDepth() {
        int i;
        int maxAuditDepth = Short.MAX_VALUE;
        ConnectionId connectionId = new ConnectionId(this.connectionIdGenerator.generateId());
        SessionId sessionId = new SessionId(connectionId, this.sessionIdGenerator.getNextSequenceId());
        ProducerId producerId = new ProducerId(sessionId, this.producerIdGenerator.getNextSequenceId());
        ActiveMQMessageAuditNoSync audit = new ActiveMQMessageAuditNoSync();
        audit.setAuditDepth(maxAuditDepth);
        MessageId msgId = new MessageId(producerId, 0L);
        for (i = 0; i < maxAuditDepth; ++i) {
            msgId.setProducerSequenceId(this.sequenceIdGenerator.getNextSequenceId());
            Assert.assertFalse((boolean)audit.isDuplicate(msgId));
        }
        for (i = 0; i < maxAuditDepth; ++i) {
            Assert.assertTrue((boolean)audit.isDuplicate(msgId));
        }
    }
}

