/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import jakarta.jms.MessageFormatException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.List;
import org.apache.activemq.broker.scheduler.CronParser;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronParserTest {
    private static final Logger LOG = LoggerFactory.getLogger(CronParserTest.class);

    @Test
    public void testgetNextTimeDayOfWeek() throws MessageFormatException {
        Calendar current = Calendar.getInstance();
        current.set(2010, 10, 15, 9, 15, 30);
        LOG.debug("start:" + current.getTime());
        String test = "* * * * 5";
        long next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)0L, (long)result.get(13));
        Assert.assertEquals((long)0L, (long)result.get(12));
        Assert.assertEquals((long)0L, (long)result.get(10));
        Assert.assertEquals((long)19L, (long)result.get(5));
        Assert.assertEquals((long)10L, (long)result.get(2));
        Assert.assertEquals((long)2010L, (long)result.get(1));
    }

    @Test
    public void testgetNextTimeDayOfWeekVariant() throws MessageFormatException {
        Calendar current = Calendar.getInstance();
        current.set(2011, 2, 7, 9, 15, 30);
        LOG.debug("start:" + current.getTime());
        String test = "50 20 * * 5";
        long next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)0L, (long)result.get(13));
        Assert.assertEquals((long)50L, (long)result.get(12));
        Assert.assertEquals((long)20L, (long)result.get(11));
        Assert.assertEquals((long)11L, (long)result.get(5));
        Assert.assertEquals((long)6L, (long)result.get(7));
        Assert.assertEquals((long)2L, (long)result.get(2));
        Assert.assertEquals((long)2011L, (long)result.get(1));
        current = Calendar.getInstance();
        current.set(2011, 2, 11, 22, 0, 30);
        LOG.debug("update:" + current.getTime());
        next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)50L, (long)result.get(12));
        Assert.assertEquals((long)20L, (long)result.get(11));
        Assert.assertEquals((long)18L, (long)result.get(5));
        Assert.assertEquals((long)6L, (long)result.get(7));
        Assert.assertEquals((long)2L, (long)result.get(2));
        Assert.assertEquals((long)2011L, (long)result.get(1));
    }

    @Test
    public void testgetNextTimeMonthVariant() throws MessageFormatException {
        Calendar current = Calendar.getInstance();
        current.set(2011, 2, 7, 9, 15, 30);
        LOG.debug("start:" + current.getTime());
        String test = "0 20 * 4,5 0";
        long next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)0L, (long)result.get(13));
        Assert.assertEquals((long)0L, (long)result.get(12));
        Assert.assertEquals((long)20L, (long)result.get(11));
        Assert.assertEquals((long)3L, (long)result.get(2));
        Assert.assertEquals((long)3L, (long)result.get(5));
        Assert.assertEquals((long)1L, (long)result.get(7));
        Assert.assertEquals((long)2011L, (long)result.get(1));
        current = Calendar.getInstance();
        current.set(2011, 3, 30, 22, 0, 30);
        LOG.debug("update:" + current.getTime());
        next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)0L, (long)result.get(13));
        Assert.assertEquals((long)0L, (long)result.get(12));
        Assert.assertEquals((long)20L, (long)result.get(11));
        Assert.assertEquals((long)1L, (long)result.get(5));
        Assert.assertEquals((long)1L, (long)result.get(7));
        Assert.assertEquals((long)4L, (long)result.get(2));
        Assert.assertEquals((long)2011L, (long)result.get(1));
        current = Calendar.getInstance();
        current.set(2011, 4, 30, 22, 0, 30);
        LOG.debug("update:" + current.getTime());
        next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)0L, (long)result.get(13));
        Assert.assertEquals((long)0L, (long)result.get(12));
        Assert.assertEquals((long)20L, (long)result.get(11));
        Assert.assertEquals((long)1L, (long)result.get(5));
        Assert.assertEquals((long)1L, (long)result.get(7));
        Assert.assertEquals((long)3L, (long)result.get(2));
        Assert.assertEquals((long)2012L, (long)result.get(1));
    }

    @Test
    public void testgetNextTimeMonth() throws MessageFormatException {
        Calendar current = Calendar.getInstance();
        current.set(2010, 10, 15, 9, 15, 30);
        LOG.debug("start:" + current.getTime());
        String test = "* * * 12 *";
        long next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)0L, (long)result.get(13));
        Assert.assertEquals((long)0L, (long)result.get(12));
        Assert.assertEquals((long)0L, (long)result.get(11));
        Assert.assertEquals((long)1L, (long)result.get(5));
        Assert.assertEquals((long)11L, (long)result.get(2));
        Assert.assertEquals((long)2010L, (long)result.get(1));
    }

    @Test
    public void testgetStartNextMonth() throws MessageFormatException {
        Calendar current = Calendar.getInstance();
        current.set(2010, 11, 15, 9, 15, 30);
        LOG.debug("start:" + current.getTime());
        String test = "* * 1 * *";
        long next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)0L, (long)result.get(13));
        Assert.assertEquals((long)0L, (long)result.get(12));
        Assert.assertEquals((long)0L, (long)result.get(11));
        Assert.assertEquals((long)1L, (long)result.get(5));
        Assert.assertEquals((long)0L, (long)result.get(2));
        Assert.assertEquals((long)2011L, (long)result.get(1));
    }

    @Test
    public void testgetNextStartCurrMonth() throws MessageFormatException {
        Calendar current = Calendar.getInstance();
        current.set(2010, 11, 15, 9, 15, 30);
        LOG.debug("start:" + current.getTime());
        String test = "* * 1 12 *";
        long next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)0L, (long)result.get(13));
        Assert.assertEquals((long)0L, (long)result.get(12));
        Assert.assertEquals((long)0L, (long)result.get(11));
        Assert.assertEquals((long)1L, (long)result.get(5));
        Assert.assertEquals((long)11L, (long)result.get(2));
        Assert.assertEquals((long)2011L, (long)result.get(1));
    }

    @Test
    public void testgetNextTimeDays() throws MessageFormatException {
        Calendar current = Calendar.getInstance();
        current.set(2010, 10, 15, 9, 15, 30);
        LOG.debug("start:" + current.getTime());
        String test = "* * 16 * *";
        long next = CronParser.getNextScheduledTime((String)test, (long)current.getTimeInMillis());
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(next);
        LOG.debug("next:" + result.getTime());
        Assert.assertEquals((long)0L, (long)result.get(13));
        Assert.assertEquals((long)0L, (long)result.get(12));
        Assert.assertEquals((long)0L, (long)result.get(10));
        Assert.assertEquals((long)16L, (long)result.get(5));
        Assert.assertEquals((long)10L, (long)result.get(2));
        Assert.assertEquals((long)2010L, (long)result.get(1));
    }

    @Test
    public void testgetNextTimeMinutes() throws MessageFormatException {
        String test = "30 * * * *";
        long current = 1200000L;
        Calendar calender = Calendar.getInstance();
        calender.setTimeInMillis(current);
        int startHours = calender.get(11);
        int startMinutes = calender.get(12);
        LOG.debug("start:" + calender.getTime());
        long next = CronParser.getNextScheduledTime((String)test, (long)current);
        calender.setTimeInMillis(next);
        LOG.debug("next:" + calender.getTime());
        int nextMinutes = calender.get(12);
        Assert.assertEquals((long)30L, (long)nextMinutes);
    }

    @Test
    public void testgetNextTimeHours() throws MessageFormatException {
        String test = "* 1 * * *";
        Calendar calender = Calendar.getInstance();
        calender.set(1972, 2, 2, 17, 10, 0);
        long current = calender.getTimeInMillis();
        long next = CronParser.getNextScheduledTime((String)test, (long)current);
        calender.setTimeInMillis(next);
        long result = next - current;
        long expected = 28860000L;
        Assert.assertEquals((long)expected, (long)result);
    }

    @Test
    public void testgetNextTimeHoursZeroMin() throws MessageFormatException {
        String test = "0 1 * * *";
        Calendar calender = Calendar.getInstance();
        calender.set(1972, 2, 2, 17, 10, 0);
        long current = calender.getTimeInMillis();
        long next = CronParser.getNextScheduledTime((String)test, (long)current);
        calender.setTimeInMillis(next);
        long result = next - current;
        long expected = 28200000L;
        Assert.assertEquals((long)expected, (long)result);
    }

    @Test
    public void testValidate() {
        try {
            CronParser.validate((String)"30 08 10 06 ? ");
            CronParser.validate((String)"30 08 ? 06 5 ");
            CronParser.validate((String)"30 08 ? 06 * ");
            CronParser.validate((String)"* * * * * ");
            CronParser.validate((String)"* * * * 1-6 ");
            CronParser.validate((String)"* * * * 1,2,5 ");
            CronParser.validate((String)"*/10 0-4,8-12 * * 1-2,3-6/2 ");
        }
        catch (Exception e) {
            Assert.fail((String)"Should be valid ");
        }
        try {
            CronParser.validate((String)"61 08 10 06 * ");
            Assert.fail((String)"Should not be valid ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CronParser.validate((String)"61 08 06 * ");
            Assert.fail((String)"Should not be valid ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetNextCommaSeparated() throws MessageFormatException {
        String token = "3,5,7";
        int next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)3, null);
        Assert.assertEquals((long)2L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)8, null);
        Assert.assertEquals((long)4L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)1, null);
        Assert.assertEquals((long)2L, (long)next);
    }

    @Test
    public void testGetNextRange() throws MessageFormatException {
        String token = "3-5";
        int next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)3, null);
        Assert.assertEquals((long)1L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)5, null);
        Assert.assertEquals((long)7L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)6, null);
        Assert.assertEquals((long)6L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 1, 10), (int)1, null);
        Assert.assertEquals((long)2L, (long)next);
    }

    @Test
    public void testGetNextExact() throws MessageFormatException {
        String token = "3";
        int next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 0, 10), (int)2, null);
        Assert.assertEquals((long)1L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 0, 10), (int)3, null);
        Assert.assertEquals((long)10L, (long)next);
        next = CronParser.getNext((CronParser.CronEntry)this.createEntry(token, 0, 10), (int)1, null);
        Assert.assertEquals((long)2L, (long)next);
    }

    @Test
    public void testTokenize() {
        String test = "*/5 * * * *";
        List list = CronParser.tokenize((String)test);
        Assert.assertEquals((long)list.size(), (long)5L);
        test = "*/5 * * * * *";
        try {
            list = CronParser.tokenize((String)test);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        test = "*/5 * * * *";
        try {
            list = CronParser.tokenize((String)test);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        test = "0 1 2 3 4";
        list = CronParser.tokenize((String)test);
        Assert.assertEquals((long)list.size(), (long)5L);
        Assert.assertEquals(list.get(0), (Object)"0");
        Assert.assertEquals(list.get(1), (Object)"1");
        Assert.assertEquals(list.get(2), (Object)"2");
        Assert.assertEquals(list.get(3), (Object)"3");
        Assert.assertEquals(list.get(4), (Object)"4");
    }

    @Test
    public void testGetNext() throws MessageFormatException {
        this.testGetNextSingle("0 0 1 * *", "2016-04-15T00:00:00", "2016-05-01T00:00:00");
        this.testGetNextSingle("0 0 1,15 * *", "2016-04-15T00:00:00", "2016-05-01T00:00:00");
        this.testGetNextSingle("0 0 1 * *", "2016-05-15T00:00:00", "2016-06-01T00:00:00");
        this.testGetNextSingle("0 0 1,15 * *", "2016-05-15T00:00:00", "2016-06-01T00:00:00");
        this.testGetNextSingle("0 0 1 * *", "2016-06-15T00:00:00", "2016-07-01T00:00:00");
        this.testGetNextSingle("0 0 1,15 * *", "2016-06-15T00:00:00", "2016-07-01T00:00:00");
    }

    private void testGetNextSingle(String cronExp, String now, String expected) throws MessageFormatException {
        LocalDateTime nowDate = LocalDateTime.parse(now);
        LocalDateTime expDate = LocalDateTime.parse(expected);
        long next = CronParser.getNextScheduledTime((String)cronExp, (long)nowDate.toInstant(OffsetDateTime.now().getOffset()).toEpochMilli());
        Assert.assertEquals((Object)expDate, (Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(next), ZoneId.systemDefault()));
    }

    public void testGetNextScheduledTime() {
        Assert.fail((String)"Not yet implemented");
    }

    CronParser.CronEntry createEntry(String str, int start, int end) {
        return new CronParser.CronEntry("test", str, start, end);
    }
}

