/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class VisibilityTest {
    static ActiveMQBytesMessage bytesMessage;
    static ByteSequence byteSequence;
    static LocalMessage localMessage;

    public static int checkNull() {
        ByteSequence local = byteSequence;
        if (local != null) {
            return local.getData().length;
        }
        return 0;
    }

    public static int checkNullReference() {
        ByteSequence local;
        ActiveMQBytesMessage message = bytesMessage;
        if (message != null && (local = message.getMarshalledProperties()) != null) {
            return local.getData().length;
        }
        return 0;
    }

    public static int checkNullReferenceOnLocalMessage() {
        ByteSequence local;
        LocalMessage message = localMessage;
        if (message != null && (local = message.getMarshalledProperties()) != null) {
            return local.getData().length;
        }
        return 0;
    }

    @Ignore
    public void doTestNested() throws Exception {
        final AtomicBoolean gotError = new AtomicBoolean();
        Thread tryingToMarshall = new Thread(new Runnable(){

            @Override
            public void run() {
                long total = 0L;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        total += (long)VisibilityTest.checkNullReference();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        gotError.set(true);
                    }
                }
                System.out.println("from other thread " + total);
            }
        });
        long len = 0L;
        tryingToMarshall.start();
        for (int t = 0; t < 10; ++t) {
            for (int i = 0; i < 1000000; ++i) {
                ActiveMQBytesMessage message = new ActiveMQBytesMessage();
                message.setBooleanProperty("B", true);
                message.beforeMarshall(null);
                bytesMessage = message;
                len += (long)message.getMarshalledProperties().getData().length;
            }
        }
        tryingToMarshall.interrupt();
        tryingToMarshall.join();
        System.out.println(len);
        Assert.assertFalse((String)"no errors, no npe!", (boolean)gotError.get());
    }

    @Test
    public void doTestNestedLocalMessage() throws Exception {
        final AtomicBoolean gotError = new AtomicBoolean();
        Thread tryingToMarshall = new Thread(new Runnable(){

            @Override
            public void run() {
                long total = 0L;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        total += (long)VisibilityTest.checkNullReferenceOnLocalMessage();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        gotError.set(true);
                    }
                }
                System.out.println("from other thread " + total);
            }
        });
        long len = 0L;
        tryingToMarshall.start();
        for (int t = 0; t < 10; ++t) {
            for (int i = 0; i < 1000000; ++i) {
                LocalMessage message = new LocalMessage();
                message.setBooleanProperty("B", true);
                message.beforeMarshall(null);
                localMessage = message;
                len += (long)message.getMarshalledProperties().getData().length;
            }
        }
        tryingToMarshall.interrupt();
        tryingToMarshall.join();
        System.out.println(len);
        Assert.assertFalse((String)"no errors, no npe!", (boolean)gotError.get());
    }

    @Ignore
    public void doTestDirect() throws Exception {
        final AtomicBoolean gotError = new AtomicBoolean();
        Thread tryingToMarshall = new Thread(new Runnable(){

            @Override
            public void run() {
                long total = 0L;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        total += (long)VisibilityTest.checkNull();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        gotError.set(true);
                    }
                }
                System.out.println("from other thread " + total);
            }
        });
        long len = 0L;
        tryingToMarshall.start();
        for (int t = 0; t < 10; ++t) {
            for (int i = 0; i < 1000000; ++i) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteSequence = byteArrayOutputStream.toByteSequence();
                len += (long)byteSequence.getData().length;
            }
        }
        tryingToMarshall.interrupt();
        tryingToMarshall.join();
        System.out.println(len);
        Assert.assertFalse((String)"no errors, no npe!", (boolean)gotError.get());
    }

    static class LocalMessage {
        public HashMap<String, Object> properties = new HashMap();
        public volatile ByteSequence marshalledProperties;
        public int total;

        LocalMessage() {
        }

        public void setBooleanProperty(String name, boolean v) {
            this.properties.put(name, v);
        }

        public void beforeMarshall(WireFormat ignored) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.total += this.properties.size();
            this.marshalledProperties = baos.toByteSequence();
        }

        public ByteSequence getMarshalledProperties() {
            return this.marshalledProperties;
        }
    }
}

