/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompWSConnection
extends WebSocketAdapter
implements WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(StompWSConnection.class);
    private Session connection;
    private final CountDownLatch connectLatch = new CountDownLatch(1);
    private final BlockingQueue<String> prefetch = new LinkedBlockingDeque<String>();
    private final StompWireFormat wireFormat = new StompWireFormat();
    private int closeCode = -1;
    private String closeMessage;

    public boolean isConnected() {
        return this.connection != null ? this.connection.isOpen() : false;
    }

    public void close() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected Session getConnection() {
        return this.connection;
    }

    public synchronized void sendRawFrame(String rawFrame) throws Exception {
        this.checkConnected();
        this.connection.getRemote().sendString(rawFrame);
    }

    public synchronized void sendFrame(StompFrame frame) throws Exception {
        this.checkConnected();
        this.connection.getRemote().sendString(this.wireFormat.marshalToString(frame));
    }

    public synchronized void keepAlive() throws Exception {
        this.checkConnected();
        this.connection.getRemote().sendString("\n");
    }

    public String receive() throws Exception {
        this.checkConnected();
        return this.prefetch.take();
    }

    public String receive(long timeout, TimeUnit unit) throws Exception {
        this.checkConnected();
        return this.prefetch.poll(timeout, unit);
    }

    public String receiveNoWait() throws Exception {
        this.checkConnected();
        return (String)this.prefetch.poll();
    }

    public void awaitConnection() throws InterruptedException {
        this.connectLatch.await();
    }

    public boolean awaitConnection(long time, TimeUnit unit) throws InterruptedException {
        return this.connectLatch.await(time, unit);
    }

    public int getCloseCode() {
        return this.closeCode;
    }

    public String getCloseMessage() {
        return this.closeMessage;
    }

    public void onWebSocketText(String data) {
        if (data == null) {
            return;
        }
        if (data.equals("\n")) {
            LOG.debug("New incoming heartbeat read");
        } else {
            LOG.trace("New incoming STOMP Frame read: \n{}", (Object)data);
            this.prefetch.add(data);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        LOG.trace("STOMP WS Connection closed, code:{} message:{}", (Object)statusCode, (Object)reason);
        this.connection = null;
        this.closeCode = statusCode;
        this.closeMessage = reason;
    }

    public void onWebSocketConnect(Session session) {
        this.connection = session;
        this.connectLatch.countDown();
    }

    private void checkConnected() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("STOMP WS Connection is closed.");
        }
    }
}

