/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuestLoginModule
implements LoginModule {
    private static final String GUEST_USER = "org.apache.activemq.jaas.guest.user";
    private static final String GUEST_GROUP = "org.apache.activemq.jaas.guest.group";
    private static final Logger LOG = LoggerFactory.getLogger(GuestLoginModule.class);
    private String userName = "guest";
    private String groupName = "guests";
    private Subject subject;
    private boolean debug;
    private boolean credentialsInvalidate;
    private Set<Principal> principals = new HashSet<Principal>();
    private CallbackHandler callbackHandler;
    private boolean loginSucceeded;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.credentialsInvalidate = "true".equalsIgnoreCase((String)options.get("credentialsInvalidate"));
        if (options.get(GUEST_USER) != null) {
            this.userName = (String)options.get(GUEST_USER);
        }
        if (options.get(GUEST_GROUP) != null) {
            this.groupName = (String)options.get(GUEST_GROUP);
        }
        this.principals.add(new UserPrincipal(this.userName));
        this.principals.add(new GroupPrincipal(this.groupName));
        if (this.debug) {
            LOG.debug("Initialized debug=" + this.debug + " guestUser=" + this.userName + " guestGroup=" + this.groupName);
        }
    }

    @Override
    public boolean login() throws LoginException {
        this.loginSucceeded = true;
        if (this.credentialsInvalidate) {
            PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
            try {
                this.callbackHandler.handle(new Callback[]{passwordCallback});
                if (passwordCallback.getPassword() != null) {
                    if (this.debug) {
                        LOG.debug("Guest login failing (credentialsInvalidate=true) on presence of a password");
                    }
                    this.loginSucceeded = false;
                    passwordCallback.clearPassword();
                }
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                // empty catch block
            }
        }
        if (this.debug) {
            LOG.debug("Guest login " + this.loginSucceeded);
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSucceeded) {
            this.subject.getPrincipals().addAll(this.principals);
        }
        if (this.debug) {
            LOG.debug("commit");
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            LOG.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        if (this.debug) {
            LOG.debug("logout");
        }
        return true;
    }
}

