/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.EncryptionSupport;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.PrincipalProperties;
import org.apache.activemq.jaas.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoginModule
implements LoginModule {
    private static final String USER_FILE = "org.apache.activemq.jaas.properties.user";
    private static final String GROUP_FILE = "org.apache.activemq.jaas.properties.group";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug;
    private boolean reload = false;
    private static volatile PrincipalProperties users;
    private static volatile PrincipalProperties groups;
    private String user;
    private final Set<Principal> principals = new HashSet<Principal>();
    private File baseDir;
    private boolean loginSucceeded;
    private boolean decrypt = true;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        File gf;
        File uf;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.loginSucceeded = false;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (options.get("reload") != null) {
            this.reload = "true".equalsIgnoreCase((String)options.get("reload"));
        }
        if (options.get("baseDir") != null) {
            this.baseDir = new File((String)options.get("baseDir"));
        }
        this.setBaseDir();
        String usersFile = (String)options.get(USER_FILE) + "";
        File file = uf = this.baseDir != null ? new File(this.baseDir, usersFile) : new File(usersFile);
        if (this.reload || users == null || uf.lastModified() > users.getReloadTime()) {
            if (this.debug) {
                LOG.debug("Reloading users from " + uf.getAbsolutePath());
            }
            users = new PrincipalProperties("user", uf, LOG);
            if (this.decrypt) {
                try {
                    EncryptionSupport.decrypt(users.getPrincipals());
                }
                catch (NoClassDefFoundError e) {
                    this.decrypt = false;
                    LOG.info("jasypt is not on the classpath: password decryption disabled.");
                }
            }
        }
        String groupsFile = (String)options.get(GROUP_FILE) + "";
        File file2 = gf = this.baseDir != null ? new File(this.baseDir, groupsFile) : new File(groupsFile);
        if (this.reload || groups == null || gf.lastModified() > groups.getReloadTime()) {
            if (this.debug) {
                LOG.debug("Reloading groups from " + gf.getAbsolutePath());
            }
            groups = new PrincipalProperties("group", gf, LOG);
        }
    }

    private void setBaseDir() {
        if (this.baseDir == null && System.getProperty("java.security.auth.login.config") != null) {
            this.baseDir = new File(System.getProperty("java.security.auth.login.config")).getParentFile();
            if (this.debug) {
                LOG.debug("Using basedir=" + this.baseDir.getAbsolutePath());
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if (this.user == null) {
            throw new FailedLoginException("user name is null");
        }
        String password = users.getProperty(this.user);
        if (password == null) {
            throw new FailedLoginException("User does exist");
        }
        if (!password.equals(new String(tmpPassword))) {
            throw new FailedLoginException("Password does not match");
        }
        this.loginSucceeded = true;
        if (this.debug) {
            LOG.debug("login " + this.user);
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.loginSucceeded;
        if (result) {
            this.principals.add(new UserPrincipal(this.user));
            block0: for (Map.Entry<String, String> entry : groups.entries()) {
                String name = entry.getKey();
                String[] userList = entry.getValue().split(",");
                for (int i = 0; i < userList.length; ++i) {
                    if (!this.user.equals(userList[i])) continue;
                    this.principals.add(new GroupPrincipal(name));
                    continue block0;
                }
            }
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.clear();
        if (this.debug) {
            LOG.debug("commit, result: " + result);
        }
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        if (this.debug) {
            LOG.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.user = null;
        this.loginSucceeded = false;
    }

    static void resetUsersAndGroupsCache() {
        users = null;
        groups = null;
    }
}

