/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.LargeFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.SmallFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class StringType
extends AbstractPrimitiveType<String> {
    private static final Charset Charset_UTF8 = Charset.forName("UTF-8");
    private static final DecoderImpl.TypeDecoder<String> _stringCreator = new DecoderImpl.TypeDecoder<String>(){

        @Override
        public String decode(ByteBuffer buf) {
            CharsetDecoder charsetDecoder = Charset_UTF8.newDecoder();
            try {
                CharBuffer charBuf = charsetDecoder.decode(buf);
                return charBuf.toString();
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException("Cannot parse String");
            }
        }
    };
    private final StringEncoding _stringEncoding;
    private final StringEncoding _shortStringEncoding;

    StringType(EncoderImpl encoder, DecoderImpl decoder) {
        this._stringEncoding = new AllStringEncoding(encoder, decoder);
        this._shortStringEncoding = new ShortStringEncoding(encoder, decoder);
        encoder.register(String.class, this);
        decoder.register(this);
    }

    @Override
    public Class<String> getTypeClass() {
        return String.class;
    }

    public StringEncoding getEncoding(String val) {
        int length = StringType.calculateUTF8Length(val);
        StringEncoding encoding = length <= 255 ? this._shortStringEncoding : this._stringEncoding;
        encoding.setValue(val, length);
        return encoding;
    }

    static int calculateUTF8Length(String s) {
        int len;
        int length = len = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if ((c & 0xFF80) == 0) continue;
            ++len;
            if ((c & 0xF800) == 0 || (c & 0xD800) == 55296) continue;
            ++len;
        }
        return len;
    }

    public StringEncoding getCanonicalEncoding() {
        return this._stringEncoding;
    }

    @Override
    public Collection<StringEncoding> getAllEncodings() {
        return Arrays.asList(this._shortStringEncoding, this._stringEncoding);
    }

    private class ShortStringEncoding
    extends SmallFloatingSizePrimitiveTypeEncoding<String>
    implements StringEncoding {
        private String _value;
        private int _length;

        public ShortStringEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(String val) {
            this.getEncoder().writeRaw(val);
        }

        @Override
        protected int getEncodedValueSize(String val) {
            return val == this._value ? this._length : StringType.calculateUTF8Length(val);
        }

        @Override
        public byte getEncodingCode() {
            return -95;
        }

        public StringType getType() {
            return StringType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<String> encoder) {
            return encoder == this;
        }

        @Override
        public String readValue() {
            DecoderImpl decoder = this.getDecoder();
            int size2 = decoder.readRawByte() & 0xFF;
            return (String)decoder.readRaw(_stringCreator, size2);
        }

        @Override
        public void setValue(String val, int length) {
            this._value = val;
            this._length = length;
        }
    }

    private class AllStringEncoding
    extends LargeFloatingSizePrimitiveTypeEncoding<String>
    implements StringEncoding {
        private String _value;
        private int _length;

        public AllStringEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(String val) {
            this.getEncoder().writeRaw(val);
        }

        @Override
        protected int getEncodedValueSize(String val) {
            return val == this._value ? this._length : StringType.calculateUTF8Length(val);
        }

        @Override
        public byte getEncodingCode() {
            return -79;
        }

        public StringType getType() {
            return StringType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<String> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public String readValue() {
            DecoderImpl decoder = this.getDecoder();
            int size2 = decoder.readRawInt();
            return (String)decoder.readRaw(_stringCreator, size2);
        }

        @Override
        public void setValue(String val, int length) {
            this._value = val;
            this._length = length;
        }
    }

    public static interface StringEncoding
    extends PrimitiveTypeEncoding<String> {
        public void setValue(String var1, int var2);
    }
}

