/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.internal.cm;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.osgi.compendium.internal.cm.BeanManagedUpdate;
import org.springframework.osgi.compendium.internal.cm.ContainerManagedUpdate;
import org.springframework.osgi.compendium.internal.cm.UpdateCallback;
import org.springframework.osgi.compendium.internal.cm.UpdateStrategy;
import org.springframework.util.Assert;

abstract class CMUtils {
    CMUtils() {
    }

    public static void applyMapOntoInstance(Object instance, Map properties, AbstractBeanFactory beanFactory) {
        if (properties != null && !properties.isEmpty()) {
            BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)instance);
            if (beanFactory != null) {
                beanFactory.copyRegisteredEditorsTo((PropertyEditorRegistry)beanWrapper);
            }
            Iterator iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String propertyName = (String)entry.getKey();
                if (!beanWrapper.isWritableProperty(propertyName)) continue;
                beanWrapper.setPropertyValue(propertyName, entry.getValue());
            }
        }
    }

    public static void bulkUpdate(UpdateCallback callback2, Collection instances, Map properties) {
        Iterator iterator = instances.iterator();
        while (iterator.hasNext()) {
            Object instance = iterator.next();
            callback2.update(instance, properties);
        }
    }

    public static UpdateCallback createCallback(UpdateStrategy strategy, String methodName, BeanFactory beanFactory) {
        if (UpdateStrategy.BEAN_MANAGED.equals((Object)strategy)) {
            Assert.hasText((String)methodName, (String)"method name required when using 'bean-managed' strategy");
            return new BeanManagedUpdate(methodName);
        }
        if (UpdateStrategy.CONTAINER_MANAGED.equals((Object)strategy)) {
            return new ContainerManagedUpdate(beanFactory);
        }
        return null;
    }
}

