/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.console.filter.AbstractQueryFilter;

public class AmqMessagesQueryFilter
extends AbstractQueryFilter {
    private URI brokerUrl;
    private Destination destination;
    private ConnectionFactory connectionFactory;

    public AmqMessagesQueryFilter(URI brokerUrl, Destination destination) {
        super(null);
        this.brokerUrl = brokerUrl;
        this.destination = destination;
    }

    public AmqMessagesQueryFilter(ConnectionFactory connectionFactory, Destination destination) {
        super(null);
        this.destination = destination;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public List query(List queries) throws Exception {
        String selector = "";
        for (Object query : queries) {
            selector = selector + "(" + query.toString() + ") AND ";
        }
        if (!selector.equals("")) {
            selector = selector.substring(0, selector.length() - 5);
        }
        if (this.destination instanceof ActiveMQQueue) {
            return this.queryMessages((ActiveMQQueue)this.destination, selector);
        }
        return this.queryMessages((ActiveMQTopic)this.destination, selector);
    }

    protected List queryMessages(ActiveMQQueue queue2, String selector) throws Exception {
        Connection conn = this.createConnection();
        Session sess = conn.createSession(false, 1);
        QueueBrowser browser = sess.createBrowser((Queue)queue2, selector);
        ArrayList messages = Collections.list(browser.getEnumeration());
        conn.close();
        return messages;
    }

    protected List queryMessages(ActiveMQTopic topic, String selector) throws Exception {
        return null;
    }

    protected Connection createConnection() throws JMSException {
        if (null == this.connectionFactory) {
            this.connectionFactory = new ActiveMQConnectionFactory(this.getBrokerUrl());
        }
        Connection conn = this.connectionFactory.createConnection();
        conn.start();
        return conn;
    }

    public URI getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(URI brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }
}

