/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;

public class ThreadPerTaskExecutor
implements Executor {
    private final ThreadFactory _threadFactory;

    public ThreadPerTaskExecutor() {
        this(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        });
    }

    public ThreadPerTaskExecutor(ThreadFactory threadFactory) {
        this._threadFactory = threadFactory;
    }

    @Override
    public void execute(Runnable task2) {
        Thread thread = this._threadFactory.newThread(task2);
        thread.start();
    }

    public static <V> Future<V> execute(Callable<V> callable) {
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        new Thread(futureTask).start();
        return futureTask;
    }
}

