/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.TransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAndXATransaction
implements XAResource,
LocalTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAndXATransaction.class);
    private TransactionContext transactionContext;
    private boolean inManagedTx;

    public LocalAndXATransaction(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public void setInManagedTx(boolean inManagedTx) throws JMSException {
        this.inManagedTx = inManagedTx;
        if (!inManagedTx) {
            this.transactionContext.cleanup();
        }
    }

    public void begin() throws ResourceException {
        try {
            this.transactionContext.begin();
            this.setInManagedTx(true);
        }
        catch (JMSException e) {
            throw new ResourceException("begin failed.", (Throwable)e);
        }
    }

    public void commit() throws ResourceException {
        try {
            this.transactionContext.commit();
        }
        catch (JMSException e) {
            throw new ResourceException("commit failed.", (Throwable)e);
        }
        finally {
            try {
                this.setInManagedTx(false);
            }
            catch (JMSException e) {
                throw new ResourceException("commit failed.", (Throwable)e);
            }
        }
    }

    public void rollback() throws ResourceException {
        try {
            this.transactionContext.rollback();
        }
        catch (JMSException e) {
            throw new ResourceException("rollback failed.", (Throwable)e);
        }
        finally {
            try {
                this.setInManagedTx(false);
            }
            catch (JMSException e) {
                throw new ResourceException("rollback failed.", (Throwable)e);
            }
        }
    }

    @Override
    public void commit(Xid arg0, boolean arg1) throws XAException {
        this.transactionContext.commit(arg0, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid arg0, int arg1) throws XAException {
        LOG.debug("{} end {} with {}", new Object[]{this, arg0, arg1});
        try {
            this.transactionContext.end(arg0, arg1);
        }
        finally {
            try {
                this.setInManagedTx(false);
            }
            catch (JMSException e) {
                throw (XAException)new XAException(-6).initCause(e);
            }
        }
    }

    @Override
    public void forget(Xid arg0) throws XAException {
        this.transactionContext.forget(arg0);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionContext.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xaresource) throws XAException {
        boolean isSame = false;
        if (xaresource != null) {
            if (xaresource instanceof LocalAndXATransaction) {
                xaresource = ((LocalAndXATransaction)xaresource).transactionContext;
            }
            isSame = this.transactionContext.isSameRM(xaresource);
        }
        LOG.trace("{} isSameRM({}) = {}", new Object[]{this, xaresource, isSame});
        return isSame;
    }

    @Override
    public int prepare(Xid arg0) throws XAException {
        return this.transactionContext.prepare(arg0);
    }

    @Override
    public Xid[] recover(int arg0) throws XAException {
        Xid[] answer = null;
        LOG.trace("{} recover({})", (Object)this, (Object)arg0);
        answer = this.transactionContext.recover(arg0);
        LOG.trace("{} recover({}) = {}", new Object[]{this, arg0, answer});
        return answer;
    }

    @Override
    public void rollback(Xid arg0) throws XAException {
        this.transactionContext.rollback(arg0);
    }

    @Override
    public boolean setTransactionTimeout(int arg0) throws XAException {
        return this.transactionContext.setTransactionTimeout(arg0);
    }

    @Override
    public void start(Xid arg0, int arg1) throws XAException {
        LOG.trace("{} start {} with {}", new Object[]{this, arg0, arg1});
        this.transactionContext.start(arg0, arg1);
        try {
            this.setInManagedTx(true);
        }
        catch (JMSException e) {
            throw (XAException)new XAException(-6).initCause(e);
        }
    }

    public boolean isInManagedTx() {
        return this.inManagedTx;
    }

    public void cleanup() {
        this.transactionContext.cleanup();
        this.inManagedTx = false;
    }

    public String toString() {
        return "[" + super.toString() + "," + this.transactionContext + "]";
    }
}

