/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportReceiver;

public class ReceiverImpl
extends LinkImpl
implements Receiver {
    private boolean _drainFlagMode = true;
    private TransportReceiver _transportReceiver;
    private int _unsentCredits;

    @Override
    public boolean advance() {
        boolean advance;
        DeliveryImpl current = this.current();
        if (current != null) {
            current.setDone();
        }
        if (advance = super.advance()) {
            this.decrementQueued();
            this.decrementCredit();
            this.getSession().incrementIncomingBytes(-current.pending());
            this.getSession().incrementIncomingDeliveries(-1);
            if (this.getSession().getTransportSession().getIncomingWindowSize().equals(UnsignedInteger.ZERO)) {
                this.modified();
            }
        }
        return advance;
    }

    ReceiverImpl(SessionImpl session, String name) {
        super(session, name);
    }

    @Override
    public void flow(int credits) {
        this.addCredit(credits);
        this._unsentCredits += credits;
        this.modified();
        if (!this._drainFlagMode) {
            this.setDrain(false);
            this._drainFlagMode = false;
        }
    }

    int clearUnsentCredits() {
        int credits = this._unsentCredits;
        this._unsentCredits = 0;
        return credits;
    }

    @Override
    public int recv(byte[] bytes, int offset, int size2) {
        if (this._current == null) {
            throw new IllegalStateException("no current delivery");
        }
        int consumed = this._current.recv(bytes, offset, size2);
        if (consumed > 0) {
            this.getSession().incrementIncomingBytes(-consumed);
            if (this.getSession().getTransportSession().getIncomingWindowSize().equals(UnsignedInteger.ZERO)) {
                this.modified();
            }
        }
        return consumed;
    }

    @Override
    public int recv(WritableBuffer buffer) {
        if (this._current == null) {
            throw new IllegalStateException("no current delivery");
        }
        int consumed = this._current.recv(buffer);
        if (consumed > 0) {
            this.getSession().incrementIncomingBytes(-consumed);
            if (this.getSession().getTransportSession().getIncomingWindowSize().equals(UnsignedInteger.ZERO)) {
                this.modified();
            }
        }
        return consumed;
    }

    @Override
    public ReadableBuffer recv() {
        if (this._current == null) {
            throw new IllegalStateException("no current delivery");
        }
        ReadableBuffer consumed = this._current.recv();
        if (consumed.remaining() > 0) {
            this.getSession().incrementIncomingBytes(-consumed.remaining());
            if (this.getSession().getTransportSession().getIncomingWindowSize().equals(UnsignedInteger.ZERO)) {
                this.modified();
            }
        }
        return consumed;
    }

    @Override
    void doFree() {
        this.getSession().freeReceiver(this);
        super.doFree();
    }

    boolean hasIncoming() {
        return false;
    }

    void setTransportLink(TransportReceiver transportReceiver) {
        this._transportReceiver = transportReceiver;
    }

    @Override
    TransportReceiver getTransportLink() {
        return this._transportReceiver;
    }

    @Override
    public void drain(int credit) {
        this.setDrain(true);
        this.flow(credit);
        this._drainFlagMode = false;
    }

    @Override
    public boolean draining() {
        return this.getDrain() && this.getCredit() > this.getQueued();
    }

    @Override
    public void setDrain(boolean drain) {
        super.setDrain(drain);
        this.modified();
        this._drainFlagMode = true;
    }

    @Override
    public int getRemoteCredit() {
        return this.getCredit() - this.getQueued();
    }
}

