/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class FloatElement
extends AtomicElement<Float> {
    private final float _value;

    FloatElement(Element parent, Element prev, float f) {
        super(parent, prev);
        this._value = f;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 4 : 5;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this._value);
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.FLOAT;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size2 = this.size();
        if (b.remaining() >= size2) {
            if (size2 == 5) {
                b.put((byte)114);
            }
            b.putFloat(this._value);
            return size2;
        }
        return 0;
    }
}

